/*
 * Decompiled with CFR 0.152.
 */
package org.openfast;

import java.math.BigDecimal;
import org.openfast.Global;
import org.openfast.ScalarValue;
import org.openfast.error.FastConstants;

public class StringValue
extends ScalarValue {
    private static final long serialVersionUID = 1L;
    public final String value;

    public StringValue(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    public byte toByte() {
        int value = this.toInt();
        if (value > 127 || value < -128) {
            Global.handleError(FastConstants.R4_NUMERIC_VALUE_TOO_LARGE, "The value \"" + value + "\" is too large to fit into a byte.");
            return 0;
        }
        return (byte)value;
    }

    public short toShort() {
        int value = this.toInt();
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            Global.handleError(FastConstants.R4_NUMERIC_VALUE_TOO_LARGE, "The value \"" + value + "\" is too large to fit into a short.");
            return 0;
        }
        return (short)value;
    }

    public int toInt() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            Global.handleError(FastConstants.R4_NUMERIC_VALUE_TOO_LARGE, "The value \"" + this.value + "\" is too large to fit into an int.", e);
            return 0;
        }
    }

    public long toLong() {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException e) {
            Global.handleError(FastConstants.R4_NUMERIC_VALUE_TOO_LARGE, "The value \"" + this.value + "\" is too large to fit into a long.", e);
            return 0L;
        }
    }

    public double toDouble() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            Global.handleError(FastConstants.R4_NUMERIC_VALUE_TOO_LARGE, "The value\"" + this.value + "\" is too large to fit into a double.", e);
            return 0.0;
        }
    }

    public Object toObject() {
        return this.value;
    }

    public byte[] getBytes() {
        return this.value.getBytes();
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.value);
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof StringValue)) {
            return false;
        }
        return this.equals((StringValue)obj);
    }

    private boolean equals(StringValue otherValue) {
        return this.value.equals(otherValue.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equalsValue(String defaultValue) {
        return this.value.equals(defaultValue);
    }
}

