/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.portfolio;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.portfolioeffect.quant.client.ClientConnection;
import com.portfolioeffect.quant.client.model.ConnectFailedException;
import com.portfolioeffect.quant.client.portfolio.ArrayCache;
import com.portfolioeffect.quant.client.portfolio.CacheKey;
import com.portfolioeffect.quant.client.portfolio.EstimatorData;
import com.portfolioeffect.quant.client.portfolio.PortfolioCache;
import com.portfolioeffect.quant.client.result.MethodResult;
import com.portfolioeffect.quant.client.util.Console;
import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Estimator {
    private static final int NUMBER_OF_TRIES = 10;
    private boolean isDebug = false;
    private EstimatorData estimatorData = new EstimatorData();
    private ClientConnection clientConnection;
    private List<CacheKey> cachedValueList;
    private PortfolioCache estimatorCache;

    public Estimator(Estimator estimator) throws Exception {
        this.estimatorData = new EstimatorData(estimator.estimatorData);
        this.clientConnection = estimator.clientConnection;
        this.cachedValueList = new ArrayList<CacheKey>();
        this.isDebug = estimator.isDebug;
        this.estimatorCache = new PortfolioCache();
    }

    public Estimator(ClientConnection clientConnection) {
        this.estimatorCache = new PortfolioCache();
        this.clientConnection = clientConnection;
        this.cachedValueList = new ArrayList<CacheKey>();
        this.setDefaultParams();
    }

    private void setDefaultParams() {
        this.estimatorData.setFromTime("#");
        this.estimatorData.setToTime("#");
        this.estimatorData.setParam("priceSamplingInterval", "1s");
        this.estimatorData.setParam("windowLength", "1s");
        this.estimatorData.setParam("samplingInterval", "all");
        this.estimatorData.setParam("jumpsModel", "moments");
        this.clearCache();
    }

    private String getMetricTypeList(String metric) throws Exception {
        String result = "";
        try {
            Gson gson = new Gson();
            Type mapTypeMetrics = new TypeToken<HashMap<String, String>>(){}.getType();
            HashMap metricArgs = (HashMap)gson.fromJson(metric, mapTypeMetrics);
            metricArgs.putAll(this.estimatorData.getSettings());
            ArrayList<HashMap> paramsArgs = new ArrayList<HashMap>();
            paramsArgs.add(metricArgs);
            result = gson.toJson(paramsArgs);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage().split(":")[1]);
        }
        return result;
    }

    public void setParam(String key, String value) {
        this.estimatorData.getSettings().put(key, value);
        this.clearCache();
    }

    public String getParam(String key) {
        if (this.estimatorData.getSettings().containsKey(key)) {
            return this.estimatorData.getSettings().get(key);
        }
        return "";
    }

    public void setEstimatorSettings(Map<String, String> map) {
        this.estimatorData.setSettings(new HashMap<String, String>(map));
        this.clearCache();
    }

    public void setEstimatorSettings(String settingsJSON) {
        this.estimatorData.setSettingJSON(settingsJSON);
        this.clearCache();
    }

    public HashMap<String, String> getEstimatorSettings() {
        return this.estimatorData.getSettings();
    }

    public String getEstimatorSettingsJSON() {
        return this.estimatorData.getSettingJSON();
    }

    public MethodResult addAsset(String assetName) {
        if (this.estimatorData.getIndexPrice() != null) {
            this.estimatorData.setIndexPrice(null);
            this.estimatorData.setIndexTimeMillisec(null);
        }
        this.estimatorData.setPriceID(this.estimatorData.getNextDataId());
        this.estimatorData.setIndexSymbol(assetName);
        this.clearCache();
        return new MethodResult();
    }

    public MethodResult addAsset(double[] indexPrice, long timeStepMilliSec) {
        long[] timeMilliSec = new long[indexPrice.length];
        for (int i = 0; i < indexPrice.length; ++i) {
            timeMilliSec[i] = (long)i * timeStepMilliSec + 1000L;
        }
        return this.addAsset(indexPrice, timeMilliSec);
    }

    public MethodResult addAsset(double[] price, long[] timeMilliSec) {
        if (this.estimatorData.getIndexPrice() != null) {
            this.estimatorData.setIndexPrice(null);
            this.estimatorData.setIndexTimeMillisec(null);
        }
        if (price.length == 0) {
            return new MethodResult("Wrong length of price vector.");
        }
        if (timeMilliSec.length == 0) {
            return new MethodResult("Wrong length of time vector.");
        }
        if (timeMilliSec.length != price.length) {
            return new MethodResult("Length of price and time vector must be the same.");
        }
        try {
            this.estimatorData.setIndexPrice(new ArrayCache(price));
            this.estimatorData.setIndexTimeMillisec(new ArrayCache(timeMilliSec));
        }
        catch (IOException e) {
            return this.processException(e);
        }
        this.estimatorData.setIndexSymbol("index");
        this.estimatorData.setPriceID(this.estimatorData.getNextDataId());
        this.clearCache();
        return new MethodResult();
    }

    public MethodResult addIndex(float[] indexPrice, long timeStepMilliSec) {
        long[] timeMilliSec = new long[indexPrice.length];
        for (int i = 0; i < indexPrice.length; ++i) {
            timeMilliSec[i] = (long)i * timeStepMilliSec + 1000L;
        }
        return this.addIndex(indexPrice, timeMilliSec);
    }

    public MethodResult addIndex(float[] price, long[] timeMilliSec) {
        if (this.estimatorData.getIndexPrice() != null) {
            this.estimatorData.setIndexPrice(null);
            this.estimatorData.setIndexTimeMillisec(null);
        }
        if (price.length == 0) {
            return new MethodResult("Wrong length of price vector.");
        }
        if (timeMilliSec.length == 0) {
            return new MethodResult("Wrong length of time vector.");
        }
        if (timeMilliSec.length != price.length) {
            return new MethodResult("Length of price and time vector must be the same.");
        }
        try {
            this.estimatorData.setIndexPrice(new ArrayCache(price));
            this.estimatorData.setIndexTimeMillisec(new ArrayCache(timeMilliSec));
        }
        catch (IOException e) {
            return this.processException(e);
        }
        this.estimatorData.setIndexSymbol("index");
        this.estimatorData.setPriceID(this.estimatorData.getNextDataId());
        this.clearCache();
        return new MethodResult();
    }

    public ClientConnection getClient() {
        return this.clientConnection;
    }

    public void clearCache() {
        for (CacheKey key : this.cachedValueList) {
            try {
                this.estimatorCache.remove(key);
            }
            catch (IOException e) {
                this.processException(e);
            }
        }
        this.cachedValueList = new ArrayList<CacheKey>();
    }

    public EstimatorData getEstimatorData() {
        return this.estimatorData;
    }

    private void processNoCashError(String str) throws Exception {
        if (str.contains("No data in cache")) {
            throw new Exception(str);
        }
    }

    private MethodResult transmitData(ArrayList<String> dataList) throws Exception {
        String[] dataTransmit;
        if (this.isDebug) {
            System.out.println("\n transmitData: " + dataList);
            System.out.println("" + this.getParam("windowLength") + "\t" + this.getParam("priceSamplingInterval") + "\t");
        }
        String windowLength = this.getParam("windowLength");
        String priceSamplingInterval = this.getParam("priceSamplingInterval");
        MethodResult result = this.clientConnection.transmitDataList(this.estimatorData.getFromTime(), this.estimatorData.getToTime(), dataList, windowLength, priceSamplingInterval, "PE");
        if (result.hasError()) {
            this.processNoCashError(result.getErrorMessage());
            return result;
        }
        if (result.getMessage().length() == 0) {
            return new MethodResult();
        }
        Gson gson = new Gson();
        Type mapType = new TypeToken<String[]>(){}.getType();
        for (String e : dataTransmit = (String[])gson.fromJson(result.getMessage(), mapType)) {
            String[] ePars = e.split("-");
            if (ePars[0].equals("h") || ePars[0].equals("hI")) {
                result = new MethodResult("Error with historical price.");
                if (!result.hasError()) continue;
                this.processNoCashError(result.getErrorMessage());
                return result;
            }
            if (ePars[0].equals("u")) {
                String position = ePars[1].split(":")[1];
                if (!position.equals("index") || !(result = this.clientConnection.transmitUserPrice(ePars[1], this.estimatorData.getIndexPrice().getFloatArray(), this.estimatorData.getIndexTimeMillisec().getLongArray())).hasError()) continue;
                this.processNoCashError(result.getErrorMessage());
                return result;
            }
            return new MethodResult("Error while transmitting data.");
        }
        return new MethodResult();
    }

    public MethodResult getMetric(String metricType) {
        if (this.estimatorData.getFromTime().length() == 0 || this.estimatorData.getToTime().length() == 0) {
            this.clientConnection.resetProgressBar();
            return new MethodResult("Set time interval  first");
        }
        for (int ii = 0; ii < 10; ++ii) {
            try {
                MethodResult result = this.clientConnection.validateStringRequest("[{no:\"no\"}]");
                if (result.hasError()) {
                    throw new Exception(result.getErrorMessage());
                }
                ArrayList<String> dataList = new ArrayList<String>();
                if (this.estimatorData.getIndexPrice() == null) {
                    dataList.add("hI-" + this.estimatorData.getPortfolioId() + ":" + this.estimatorData.getIndexSymbol() + ":" + this.estimatorData.getPriceID());
                    this.setParam("indexName", "hI-" + this.estimatorData.getPortfolioId() + ":" + this.estimatorData.getIndexSymbol() + ":" + this.estimatorData.getPriceID());
                } else {
                    dataList.add("u-" + this.estimatorData.getPortfolioId() + ":" + "index" + ":" + this.estimatorData.getPriceID());
                    this.setParam("indexName", this.estimatorData.getPortfolioId() + ":" + "index" + ":" + this.estimatorData.getPriceID());
                }
                String metricTypeFull = this.getMetricTypeList(metricType);
                CacheKey key = new CacheKey(metricTypeFull, "");
                if (this.estimatorCache.containsKey(key)) {
                    MethodResult result2 = new MethodResult();
                    result2.setData("value", this.estimatorCache.getMetric(key));
                    result2.setData("time", this.estimatorCache.getTime(key));
                    return result2;
                }
                this.clientConnection.printProgressBar(0.0);
                MethodResult result3 = null;
                MethodResult resultTransmit = this.transmitData(dataList);
                if (resultTransmit.hasError()) {
                    this.clientConnection.resetProgressBar();
                    return new MethodResult(resultTransmit.getErrorMessage());
                }
                if (this.isDebug) {
                    Console.writeln("\n " + metricTypeFull);
                }
                if (!(result3 = this.clientConnection.estimateEstimator(metricTypeFull)).hasError()) {
                    this.estimatorCache.addMetric(key, result3.getDataArrayCache("value"));
                    this.estimatorCache.addTime(key, result3.getDataArrayCache("time"));
                    this.cachedValueList.add(key);
                } else {
                    this.clientConnection.createCallGroup(1);
                }
                return result3;
            }
            catch (Exception e) {
                MethodResult result = this.processException(e);
                if (result == null) continue;
                return result;
            }
        }
        this.clientConnection.resetProgressBar();
        return new MethodResult("Failed to complete estimation procedure - cannot connect to server. Server request failed due to a timeout.");
    }

    private MethodResult processException(Exception e) {
        if (this.isDebug) {
            Console.writeStackTrace(e);
        }
        if (e instanceof ConnectFailedException) {
            MethodResult isRestarted = this.clientConnection.restart();
            if (isRestarted.hasError()) {
                this.clientConnection.resetProgressBar();
                return new MethodResult(isRestarted.getErrorMessage());
            }
            return null;
        }
        if (e.getMessage() == null || e.getMessage().contains("No data in cache") || e.getMessage().contains("null")) {
            MethodResult isRestarted = this.clientConnection.restart();
            if (isRestarted.hasError()) {
                this.clientConnection.resetProgressBar();
                return new MethodResult(isRestarted.getErrorMessage());
            }
            return null;
        }
        if (e.getMessage() == null) {
            Console.writeStackTrace(e);
            return new MethodResult("Unknown error.");
        }
        this.clientConnection.resetProgressBar();
        return new MethodResult(e.getMessage());
    }

    private MethodResult processException(IOException e) {
        if (this.isDebug) {
            Console.writeStackTrace(e);
        }
        if (e.getMessage() != null) {
            return new MethodResult(e.getMessage());
        }
        return new MethodResult("Error while working with the local file system");
    }

    public void createCallGroup(int groupSize) {
        this.clientConnection.createCallGroup(groupSize);
    }

    public boolean isPriceJumpsFilterEnabled() {
        return this.getParam("isPriceJumpsFilterEnabled").equals("true");
    }

    public String getFromTime() {
        return this.estimatorData.getFromTime();
    }

    public MethodResult setFromTime(String fromTime) {
        this.updatePriceData();
        this.estimatorData.setFromTime("");
        if (fromTime.contains("t")) {
            if (fromTime.trim().equals("t")) {
                this.estimatorData.setFromTime(fromTime);
                return new MethodResult();
            }
            String[] a = fromTime.trim().split("-");
            try {
                this.estimatorData.setFromTime(fromTime);
                return new MethodResult();
            }
            catch (Exception e) {
                return new MethodResult(String.format("Wrong time format: fromTime= %s", fromTime));
            }
        }
        if (!fromTime.contains(":")) {
            String s = fromTime.trim() + " 09:30:01";
            try {
                Timestamp t = Timestamp.valueOf(s);
                this.estimatorData.setFromTime(fromTime);
                return new MethodResult();
            }
            catch (Exception e) {
                return new MethodResult(String.format("Wrong time format: fromTime= %s", fromTime));
            }
        }
        try {
            Timestamp t = Timestamp.valueOf(fromTime);
        }
        catch (Exception e) {
            return new MethodResult(String.format("Wrong time format: fromTime= %s", fromTime));
        }
        this.estimatorData.setFromTime(fromTime);
        return new MethodResult();
    }

    public String getToTime() {
        return this.estimatorData.getToTime();
    }

    public void updatePriceData() {
        this.estimatorData.setPriceID(this.estimatorData.getNextDataId());
        this.clearCache();
    }

    public MethodResult setToTime(String toTime) {
        this.updatePriceData();
        this.estimatorData.setToTime("");
        if (toTime.contains("t")) {
            if (toTime.trim().equals("t")) {
                this.estimatorData.setToTime(toTime);
                return new MethodResult();
            }
            String[] a = toTime.trim().split("-");
            try {
                int daysBack = Integer.parseInt(a[1].split("d")[0]);
                this.estimatorData.setToTime(toTime);
                return new MethodResult();
            }
            catch (Exception e) {
                return new MethodResult(String.format("Wrong time format: toTime= %s", toTime));
            }
        }
        if (!toTime.contains(":")) {
            String s = toTime.trim() + " 09:30:01";
            try {
                Timestamp t = Timestamp.valueOf(s);
                this.estimatorData.setToTime(toTime);
                return new MethodResult();
            }
            catch (Exception e) {
                return new MethodResult(String.format("Wrong time format: toTime= %s", toTime));
            }
        }
        try {
            Timestamp t = Timestamp.valueOf(toTime);
        }
        catch (Exception e) {
            return new MethodResult(String.format("Wrong time format: toTime= %s", toTime));
        }
        this.estimatorData.setToTime(toTime);
        return new MethodResult();
    }

    public String getSamplingInterval() {
        return this.getParam("samplingInterval");
    }

    public void setSamplingInterval(String samplingIntervalServer) {
        this.setParam("samplingInterval", samplingIntervalServer);
        this.clearCache();
    }

    protected void finalize() throws Throwable {
        this.clearCache();
        super.finalize();
    }

    public String getPriceSamplingInterval() {
        return this.getParam("priceSamplingInterval");
    }

    public void setPriceSamplingInterval(String priceSamplingInterval) {
        this.setParam("priceSamplingInterval", priceSamplingInterval);
        this.clearCache();
    }

    public String getIndexSymbol() {
        return this.estimatorData.getIndexSymbol();
    }

    public String getFactorModel() {
        return this.getParam("factorModel");
    }

    public boolean isJumpsModelEnabled() {
        return this.getParam("isJumpsModelEnabled").equals("true");
    }

    public void setJumpsModel(String jumpsModel) {
        this.setParam("jumpsModel", jumpsModel);
        this.clearCache();
    }

    public String getJumpsModel() {
        return this.getParam("jumpsModel");
    }

    public String getWindowLength() {
        return this.getParam("windowLength");
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public long getNewDataId() {
        return this.estimatorData.getNextDataId();
    }

    public ClientConnection getClientConnection() {
        return this.clientConnection;
    }

    public void setClientConnection(ClientConnection clientConnection) {
        this.clientConnection = clientConnection;
    }

    public MethodResult getAllSymbolsList() {
        for (int ii = 0; ii < 10; ++ii) {
            try {
                return this.clientConnection.getAllSymbolsList();
            }
            catch (Exception e) {
                MethodResult result = this.processException(e);
                if (result == null) continue;
                return result;
            }
        }
        return new MethodResult("Failed to complete estimation procedure - cannot connect to server. Server request failed due to a timeout.");
    }
}

