/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.session;

import java.io.IOException;
import java.net.SocketException;
import org.openfast.Context;
import org.openfast.Message;
import org.openfast.MessageInputStream;
import org.openfast.MessageOutputStream;
import org.openfast.OpenFastContext;
import org.openfast.QName;
import org.openfast.error.ErrorCode;
import org.openfast.error.ErrorHandler;
import org.openfast.error.FastConstants;
import org.openfast.error.FastException;
import org.openfast.session.BasicOpenFastContext;
import org.openfast.session.Client;
import org.openfast.session.Connection;
import org.openfast.session.FastConnectionException;
import org.openfast.session.MessageListener;
import org.openfast.session.SessionConstants;
import org.openfast.session.SessionListener;
import org.openfast.session.SessionProtocol;
import org.openfast.template.MessageTemplate;
import org.openfast.template.TemplateRegistry;

public class Session
implements ErrorHandler {
    public final MessageInputStream in;
    public final MessageOutputStream out;
    private final SessionProtocol protocol;
    private final Connection connection;
    private Client client;
    private MessageListener messageListener;
    private boolean listening;
    private Thread listeningThread;
    private ErrorHandler errorHandler = ErrorHandler.DEFAULT;
    private SessionListener sessionListener = SessionListener.NULL;
    private OpenFastContext context = new BasicOpenFastContext();

    public Session(Connection connection, SessionProtocol protocol, TemplateRegistry inboundRegistry, TemplateRegistry outboundRegistry) {
        Context inContext = new Context(this.context);
        inContext.getTemplateRegistry().registerAll(inboundRegistry);
        Context outContext = new Context(this.context);
        outContext.getTemplateRegistry().registerAll(outboundRegistry);
        inContext.setErrorHandler(this);
        this.connection = connection;
        this.protocol = protocol;
        try {
            this.in = new MessageInputStream(connection.getInputStream(), inContext);
            this.out = new MessageOutputStream(connection.getOutputStream(), outContext);
        }
        catch (IOException e) {
            this.errorHandler.error(null, "Error occurred in connection.", e);
            throw new IllegalStateException(e);
        }
        protocol.configureSession(this);
    }

    public void close() throws FastConnectionException {
        this.listening = false;
        this.out.writeMessage(this.protocol.getCloseMessage());
        this.in.close();
        this.out.close();
    }

    public void close(ErrorCode alertCode) {
        this.listening = false;
        this.in.close();
        this.out.close();
        this.sessionListener.onClose();
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Client getClient() {
        return this.client;
    }

    public void error(ErrorCode code, String message) {
        if (code.equals(FastConstants.D9_TEMPLATE_NOT_REGISTERED)) {
            code = SessionConstants.TEMPLATE_NOT_SUPPORTED;
            message = "Template Not Supported: " + message;
        }
        this.protocol.onError(this, code, message);
        this.errorHandler.error(code, message);
    }

    public void error(ErrorCode code, String message, Throwable t) {
        this.protocol.onError(this, code, message);
        this.errorHandler.error(code, message, t);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            this.errorHandler = ErrorHandler.NULL;
        }
        this.errorHandler = errorHandler;
    }

    public OpenFastContext getContext() {
        return this.context;
    }

    public void reset() {
        this.out.reset();
        this.in.reset();
        this.out.writeMessage(this.protocol.getResetMessage());
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setMessageHandler(MessageListener messageListener) {
        this.messageListener = messageListener;
        this.setListening(true);
    }

    private void listenForMessages() {
        if (this.listeningThread == null) {
            Runnable messageReader = new Runnable(){

                public void run() {
                    while (Session.this.listening) {
                        try {
                            Message message = Session.this.in.readMessage();
                            if (message == null) {
                                this.notifySessionClosed();
                                break;
                            }
                            if (Session.this.protocol.isProtocolMessage(message)) {
                                Session.this.protocol.handleMessage(Session.this, message);
                                continue;
                            }
                            if (Session.this.messageListener != null) {
                                Session.this.messageListener.onMessage(Session.this, message);
                                continue;
                            }
                            throw new IllegalStateException("Received non-protocol message without a message listener.");
                        }
                        catch (Exception e) {
                            Throwable cause = e.getCause();
                            if (cause != null && cause.getClass().equals(SocketException.class)) {
                                this.notifySessionClosed();
                                Session.this.errorHandler.error(FastConstants.IO_ERROR, cause.getMessage(), cause);
                                continue;
                            }
                            if (e instanceof FastException) {
                                FastException fastException = (FastException)e;
                                Session.this.errorHandler.error(fastException.getCode(), fastException.getMessage(), e);
                                continue;
                            }
                            Session.this.errorHandler.error(FastConstants.GENERAL_ERROR, e.getMessage(), e);
                        }
                    }
                }

                private void notifySessionClosed() {
                    Session.this.listening = false;
                    if (Session.this.sessionListener != null) {
                        Session.this.sessionListener.onClose();
                    }
                }
            };
            this.listeningThread = new Thread(messageReader, "FAST Session Message Reader");
        }
        if (this.listeningThread.isAlive()) {
            return;
        }
        this.listeningThread.start();
    }

    public void setListening(boolean listening) {
        this.listening = listening;
        if (listening) {
            this.listenForMessages();
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void sendTemplates(TemplateRegistry registry) {
        if (!this.protocol.supportsTemplateExchange()) {
            throw new UnsupportedOperationException("The procotol " + this.protocol + " does not support template exchange.");
        }
        MessageTemplate[] templates = registry.getTemplates();
        int i = 0;
        while (i < templates.length) {
            MessageTemplate template = templates[i];
            this.out.writeMessage(this.protocol.createTemplateDefinitionMessage(template));
            this.out.writeMessage(this.protocol.createTemplateDeclarationMessage(template, registry.getId(template)));
            if (!this.out.getTemplateRegistry().isRegistered(template)) {
                this.out.registerTemplate(registry.getId(template), template);
            }
            ++i;
        }
    }

    public void addDynamicTemplateDefinition(MessageTemplate template) {
        this.in.getTemplateRegistry().define(template);
        this.out.getTemplateRegistry().define(template);
    }

    public void registerDynamicTemplate(QName templateName, int id) {
        if (!this.in.getTemplateRegistry().isDefined(templateName)) {
            throw new IllegalStateException("Template " + templateName + " has not been defined.");
        }
        this.in.getTemplateRegistry().register(id, templateName);
        if (!this.out.getTemplateRegistry().isDefined(templateName)) {
            throw new IllegalStateException("Template " + templateName + " has not been defined.");
        }
        this.out.getTemplateRegistry().register(id, templateName);
    }

    public void setSessionListener(SessionListener sessionListener) {
        this.sessionListener = sessionListener;
    }
}

