/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.session.multicast;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.openfast.session.Connection;
import org.openfast.session.ConnectionListener;
import org.openfast.session.FastConnectionException;
import org.openfast.session.multicast.MulticastConnection;
import org.openfast.session.multicast.MulticastEndpoint;

public class MulticastClientEndpoint
extends MulticastEndpoint {
    public MulticastClientEndpoint(int port, String group) {
        super(port, group);
    }

    public MulticastClientEndpoint(int port, String group, String ifaddr) {
        super(port, group, ifaddr);
    }

    public Connection connect() throws FastConnectionException {
        try {
            MulticastSocket socket = this.createSocket();
            InetAddress groupAddress = InetAddress.getByName(this.group);
            socket.joinGroup(groupAddress);
            return new MulticastConnection(socket, this.port, groupAddress);
        }
        catch (IOException e) {
            throw new FastConnectionException(e);
        }
    }

    public void accept() throws FastConnectionException {
        throw new UnsupportedOperationException();
    }

    public void setConnectionListener(ConnectionListener listener) {
        throw new UnsupportedOperationException();
    }
}

