/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.type.codec;

import java.io.InputStream;
import java.util.Date;
import org.openfast.DateValue;
import org.openfast.IntegerValue;
import org.openfast.ScalarValue;
import org.openfast.template.type.codec.TypeCodec;
import org.openfast.util.Util;

public class TimeInteger
extends TypeCodec {
    private static final long serialVersionUID = 1L;

    public ScalarValue decode(InputStream in) {
        int intValue = ((IntegerValue)TypeCodec.UINT.decode((InputStream)in)).value;
        int hour = intValue / 10000000;
        int minute = (intValue -= hour * 10000000) / 100000;
        int second = (intValue -= minute * 100000) / 1000;
        int millisecond = (intValue -= second * 1000) % 1000;
        return new DateValue(new Date(hour * 3600000 + minute * 60000 + second * 1000 + millisecond));
    }

    public byte[] encodeValue(ScalarValue value) {
        Date date = ((DateValue)value).value;
        int intValue = Util.timeToInt(date);
        return TypeCodec.UINT.encode(new IntegerValue(intValue));
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

