/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.result;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.portfolioeffect.quant.client.model.ComputeErrorException;
import com.portfolioeffect.quant.client.portfolio.Portfolio;
import com.portfolioeffect.quant.client.portfolio.PortfolioContainer;
import com.portfolioeffect.quant.client.result.AbstractMethodResult;
import com.portfolioeffect.quant.client.result.Metric;
import com.portfolioeffect.quant.client.type.MetricsTypeFull;
import com.portfolioeffect.quant.client.util.LazyMetricBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;

public class LazyMetric
extends AbstractMethodResult {
    private Portfolio portfolio;
    private String metricType;
    private HashMap<String, String> metricMapFull;
    private HashMap<String, String> metricParams;
    private final LazyMetricBuilder lazyMetricBuilder;
    private HashMap<String, String> portfolioParams;
    private boolean isComputed = false;
    private LazyMetric timeShift = null;

    public LazyMetric(Metric result) {
        this.lazyMetricBuilder = null;
        this.isComputed = true;
        this.isDebug = result.isDebug;
        this.hasResult = result.hasResult;
        this.hasError = result.hasError;
        this.hasWarning = result.hasWarning;
        this.errorMessage = result.errorMessage;
        this.warningMessage = result.warningMessage;
        this.message = result.message;
        this.infoParams = result.infoParams;
        this.data = new HashMap(result.data);
        this.dataType = new HashMap(result.dataType);
        this.portfolio = null;
    }

    public LazyMetric(PortfolioContainer container, String metricType, String metricTypeFull, LazyMetricBuilder builder) {
        this.portfolio = new Portfolio(container);
        this.metricType = metricTypeFull;
        Gson gson = new Gson();
        Type mapType = new TypeToken<HashMap<String, String>>(){}.getType();
        this.metricMapFull = (HashMap)gson.fromJson(metricTypeFull, mapType);
        this.metricParams = (HashMap)gson.fromJson(metricType, mapType);
        this.portfolioParams = new HashMap<String, String>(this.portfolio.getPortfolioData().getPortfolioSettings());
        this.portfolioParams.putAll(this.portfolio.getPortfolioData().getEstimatorSettings());
        this.lazyMetricBuilder = new LazyMetricBuilder(builder);
    }

    public LazyMetric(String errorMessage) {
        super(errorMessage);
        this.lazyMetricBuilder = null;
    }

    public LazyMetric(String errorMessage, String warnnigMessage) {
        super(errorMessage, warnnigMessage);
        this.lazyMetricBuilder = null;
    }

    public LazyMetric(boolean hasError, String errorMessage) {
        super(hasError, errorMessage);
        this.lazyMetricBuilder = null;
    }

    public String getMetricType() {
        return this.metricType;
    }

    public Portfolio getPortfolio() {
        return this.portfolio;
    }

    @Override
    public void compute() {
        block9: {
            if (this.metricType == null) {
                this.isComputed = true;
            }
            if (this.isComputed) {
                return;
            }
            try {
                if (!this.portfolio.isContainsResult(this.metricType)) {
                    this.portfolio.finishBatch();
                }
            }
            catch (Exception e) {
                if (!this.isDebug) break block9;
                e.printStackTrace();
            }
        }
        Metric result = this.portfolio.getMetric(this.metricType);
        this.isComputed = true;
        this.isDebug = result.isDebug;
        this.hasResult = result.hasResult;
        this.hasError = result.hasError;
        this.hasWarning = result.hasWarning;
        this.errorMessage = result.errorMessage;
        this.warningMessage = result.warningMessage;
        this.message = result.message;
        this.infoParams = result.infoParams;
        this.data = new HashMap(result.data);
        this.dataType = result.dataType;
        this.portfolio.del();
        this.portfolio = null;
        if (this.timeShift != null) {
            try {
                this.addShiftToTime(this.timeShift);
            }
            catch (ComputeErrorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void computeMetric() throws ComputeErrorException {
        this.compute();
        if (this.hasError) {
            throw new ComputeErrorException(this.errorMessage);
        }
    }

    public String getDescription() {
        String description = "";
        MetricsTypeFull metric = MetricsTypeFull.valueOf(this.metricMapFull.get("metric").trim());
        description = metric.getDescription();
        if (this.metricMapFull.containsKey("goal")) {
            description = String.valueOf(description) + "(" + this.getDescription(this.metricMapFull.get("goal")) + ")";
        }
        String[][] args = metric.getMetricArguments();
        int i = 0;
        while (i < args.length) {
            description = i == 0 ? String.valueOf(description) + ": " : String.valueOf(description) + ", ";
            description = String.valueOf(description) + args[i][1] + "=" + this.metricMapFull.get(args[i][0]);
            ++i;
        }
        description = String.valueOf(description);
        return description;
    }

    private String getDescription(String str) {
        Gson gson = new Gson();
        Type mapType = new TypeToken<HashMap<String, String>>(){}.getType();
        HashMap metricMap = (HashMap)gson.fromJson(str, mapType);
        String description = "";
        MetricsTypeFull metric = MetricsTypeFull.valueOf(((String)metricMap.get("metric")).trim());
        description = metric.getDescription();
        String[][] args = metric.getMetricArguments();
        int i = 0;
        while (i < args.length) {
            description = i == 0 ? String.valueOf(description) + ": " : String.valueOf(description) + ", ";
            description = String.valueOf(description) + args[i][1] + "=" + (String)metricMap.get(args[i][0]);
            ++i;
        }
        description = String.valueOf(description);
        return description;
    }

    public String getSymbol() {
        if (this.metricMapFull.containsKey("position")) {
            return this.metricMapFull.get("position");
        }
        return "Portfolio";
    }

    @Override
    protected void finalize() throws Throwable {
        this.portfolio = null;
        super.finalize();
    }

    public HashMap<String, String> getMetricParams() {
        return this.metricParams;
    }

    public HashMap<String, String> getPortfolioParams() {
        return this.portfolioParams;
    }

    public LazyMetricBuilder getLazyMetricBuilder() {
        return new LazyMetricBuilder(this.lazyMetricBuilder);
    }

    public void setTimeShift(LazyMetric timeShift) {
        this.timeShift = timeShift;
    }

    public LazyMetric addInput(LazyMetric[] metrics) throws Exception {
        LazyMetricBuilder builder = new LazyMetricBuilder(this.lazyMetricBuilder);
        LazyMetricBuilder builderIn = metrics[0].getLazyMetricBuilder();
        if (builderIn.contains("forecastStep") && builderIn.contains("timeShift")) {
            builder.setParam("forecastStep", builderIn.getParam("forecastStep"));
            builder.setParam("timeShift", builderIn.getParam("timeShift"));
        }
        LazyMetric[] lazyMetricArray = metrics;
        int n = metrics.length;
        int n2 = 0;
        while (n2 < n) {
            LazyMetric e = lazyMetricArray[n2];
            String metricType = e.getLazyMetricBuilder().getParam("metricType");
            builder.setParam(metricType, e);
            ++n2;
        }
        return builder.build(this.portfolio);
    }

    public LazyMetric addInput(LazyMetric metric) throws Exception {
        return this.addInput(new LazyMetric[]{metric});
    }
}

