/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client;

import com.portfolioeffect.quant.client.ConnectionToServer;
import com.portfolioeffect.quant.client.Connector;
import com.portfolioeffect.quant.client.message.type.FastMessageType;
import com.portfolioeffect.quant.client.model.PriceDataSet;
import com.portfolioeffect.quant.client.result.Metric;
import com.portfolioeffect.quant.client.util.MetricUpdateCallback;
import com.portfolioeffect.quant.client.util.ProgressBar;
import com.portfolioeffect.quant.client.util.SimpleMetricUpdateCallback;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.openfast.Message;
import org.openfast.session.FastConnectionException;
import org.openfast.template.TemplateRegistry;

public class ClientConnection {
    private static final String SUPPORTED_CHARSET = "US-ASCII";
    private static final int PORT_NUMBER = 443;
    private AtomicBoolean isStreamEnabled = new AtomicBoolean(false);
    private AtomicBoolean isStreamRuning = new AtomicBoolean(false);
    private boolean isMessageLoggingEnabled = true;
    private boolean debugModeEnabled = false;
    private int groupSize = 1;
    private int progressBarI = 0;
    private int progressBarMax = 0;
    private ProgressBar progressBar = new ProgressBar();
    private MetricUpdateCallback streamRefreshCallback = null;
    private SimpleMetricUpdateCallback streamRefreshCallbackPureData = null;
    private Connector connector;
    private long idClient;
    private List<String> batchMetricKeys = null;
    private static AtomicLong idClientGenerator;
    private static AtomicLong id;

    public static long getNewId() {
        return id.incrementAndGet();
    }

    public long getIdClient() {
        return this.idClient;
    }

    public ClientConnection(ClientConnection client) {
        this.isStreamEnabled = new AtomicBoolean(false);
        this.isStreamRuning = new AtomicBoolean(false);
        this.isMessageLoggingEnabled = client.isMessageLoggingEnabled;
        this.debugModeEnabled = client.debugModeEnabled;
        this.groupSize = 1;
        this.progressBarI = 0;
        this.progressBarMax = 0;
        this.progressBar = new ProgressBar();
        this.streamRefreshCallback = null;
        this.streamRefreshCallbackPureData = null;
        this.connector = new Connector(client.connector);
        this.idClient = idClientGenerator.getAndIncrement();
        this.batchMetricKeys = null;
        this.progressBar = new ProgressBar(client.progressBar);
    }

    public ClientConnection() {
        this.connector = ConnectionToServer.getCurentConnection().getCurentConnector(null, -1);
        this.setMessageLoggingEnabled(false);
        this.setPort(443);
        this.idClient = idClientGenerator.getAndIncrement();
    }

    public long getIdC() {
        return this.idClient;
    }

    public void stop() {
        this.connector.stop();
    }

    public void progressBarIAdd(int value) {
        if (this.progressBarMax == 0) {
            this.progressBarMax = value * this.groupSize;
            this.progressBarI = 0;
        }
        this.progressBar.printCompletionStatus(this.progressBarI, this.progressBarMax);
        this.progressBarI += value;
        this.progressBar.printCompletionStatus(this.progressBarI, this.progressBarMax);
        if (this.progressBarI == this.progressBarMax) {
            this.createCallGroup(1);
        }
    }

    public void createCallGroup(int groupSize) {
        this.groupSize = groupSize;
        this.progressBarI = 0;
        this.progressBarMax = 0;
        this.progressBar.reset();
        this.progressBar.setScale(groupSize);
    }

    public void printProgressBar(double percent) {
        this.progressBar.printCompletionStatus(percent);
    }

    public void proggressBarOn() {
        this.progressBar.setON(true);
    }

    public void proggressBarOff() {
        this.progressBar.setON(false);
    }

    public void resetProgressBar() {
        this.progressBar.reset();
    }

    public Metric start(String username, String password, String apiKey, String remoteHostName) {
        return this.connector.start(username, password, apiKey, remoteHostName);
    }

    public Metric restart() {
        return this.connector.restart();
    }

    public double getDataVolume(double[] price, int[] timeSec) {
        PriceDataSet data;
        try {
            data = new PriceDataSet(price, timeSec);
        }
        catch (Exception e) {
            return 0.0;
        }
        double a = data.toBinaryZipCompress().length;
        return a / 1024.0 / 1024.0;
    }

    public double getDataVolume(double[] price) {
        return this.getDataVolume(price, new int[0]);
    }

    public boolean isPureAscii(String v) {
        CharsetEncoder asciiEncoder = Charset.forName(SUPPORTED_CHARSET).newEncoder();
        return asciiEncoder.canEncode(v);
    }

    public void stopStream() {
        this.isStreamEnabled.set(false);
        this.stop();
        this.batchMetricKeys = null;
    }

    public List<String> getBatchMetricKeys() {
        return this.batchMetricKeys;
    }

    public void setBatchMetricKeys(List<String> batchMetricKeys, long portfolioID) {
        this.batchMetricKeys = new ArrayList<String>();
        for (String e : batchMetricKeys) {
            if (e.charAt(0) == '{' && e.length() > 1) {
                this.batchMetricKeys.add("{portfolioID:" + portfolioID + ", request:" + e);
                continue;
            }
            this.batchMetricKeys.add(e);
        }
    }

    Message sendAndAwaitResponse(Message request, int timeoutSec) throws Exception {
        return this.connector.sendAndAwaitResponse(request, timeoutSec);
    }

    public void send(Message request) throws Exception {
        this.connector.send(request);
    }

    public Message awaitResponse() throws Exception {
        return this.connector.awaitResponse();
    }

    public TemplateRegistry getTemplateRegistry() throws Exception {
        return this.connector.getTemplateRegistry();
    }

    FastMessageType getMessageType(Message msg) {
        String msgTypeCode = msg.getString("MessageType");
        FastMessageType fastMsgType = FastMessageType.getFastMessageType(msgTypeCode);
        return fastMsgType;
    }

    void sendToSelf(Message msg) {
        this.connector.sendToSelf(msg);
    }

    public void setHost(String host) {
        this.connector.setHost(host);
    }

    public String getApiKey() {
        return this.connector.getApiKey();
    }

    public void setApiKey(String apiKey) {
        this.connector.setApiKey(apiKey);
    }

    public String getUsername() {
        return this.connector.getUsername();
    }

    public void setUsername(String username) {
        this.connector.setUsername(username);
    }

    public String getPassword() {
        return this.connector.getPassword();
    }

    public void setPassword(String password) {
        this.connector.setPassword(password);
    }

    public int getPort() {
        return this.connector.getPort();
    }

    public void setPort(int port) {
        this.connector.setPort(port);
    }

    public String getHost() {
        return this.connector.getHost();
    }

    public void setMessageLoggingEnabled(boolean isMessageLoggingEnabled) {
        this.isMessageLoggingEnabled = isMessageLoggingEnabled;
    }

    public boolean isMessageLoggingEnabled() {
        return this.isMessageLoggingEnabled;
    }

    public int getOutboundMsgSequenceNumber() {
        return this.connector.getOutboundMsgSequenceNumber();
    }

    public boolean isDebugModeEnabled() {
        return this.debugModeEnabled;
    }

    public void setDebugModeEnabled(boolean debugModeEnabled) {
        this.debugModeEnabled = debugModeEnabled;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void setStreamRefreshCallback(MetricUpdateCallback streamRefreshCallback) {
        this.streamRefreshCallback = streamRefreshCallback;
    }

    public SimpleMetricUpdateCallback getStreamRefreshCallbackPureData() {
        return this.streamRefreshCallbackPureData;
    }

    public void setStreamRefreshCallbackPureData(SimpleMetricUpdateCallback streamRefreshCallbackPureData) {
        this.streamRefreshCallbackPureData = streamRefreshCallbackPureData;
    }

    public int getRestarTimeWait() {
        return this.connector.getRestarTimeWait();
    }

    public void setRestarTimeWait(int restarTimeWait) {
        this.connector.setRestarTimeWait(restarTimeWait);
    }

    public void start() throws IOException, FastConnectionException {
        this.connector.start();
    }

    public void logon() {
        this.connector.logon();
    }

    public void makeAsincConnection(boolean isMultiplex) {
        if (isMultiplex) {
            this.connector = ConnectionToServer.getCurentConnection().getNewConnector(this.connector);
        } else {
            ConnectionToServer.resetConnection();
            this.connector = ConnectionToServer.getCurentConnection().getCurentConnector(this.connector, this.connector.getUID());
        }
    }

    public void makeSincConnection() {
        this.connector = ConnectionToServer.getCurentConnection().getCurentConnector(this.connector, this.connector.getUID());
    }

    public void setTemplatesFileName(String string) {
        this.connector.setTemplatesFileName(string);
    }

    public void printCompletionStatus(double percent) {
        this.progressBar.printCompletionStatus(percent);
    }

    public void setStreamEnabled(boolean f) {
        this.isStreamEnabled.set(f);
    }

    public boolean isStreamEnabled() {
        return this.isStreamEnabled.get();
    }

    public void setStreamRuning(boolean f) {
        this.isStreamRuning.set(f);
    }

    public boolean isStreamRuning() {
        return this.isStreamRuning.get();
    }

    public MetricUpdateCallback getStreamRefreshCallback() {
        return this.streamRefreshCallback;
    }

    static {
        id = new AtomicLong();
        idClientGenerator = new AtomicLong();
    }
}

