% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thomas.tri.sol.R
\name{thomas.tri.sol}
\alias{thomas.tri.sol}
\title{Solve the linear equation (-Q-zI)w=v.}
\usage{
thomas.tri.sol(Q, v, z)
}
\arguments{
\item{Q}{The given tridiagonal matrix.}

\item{v}{The column vector on the right hand of  equation.}

\item{z}{The Rayleigh shift.}
}
\value{
A solution sequence \eqn{w} to the equation (-Q-zI)w=v.
}
\description{
Construct the solution of linear equation (-Q-zI)w=v.
}
\examples{
nn = 8
a = c(1:(nn - 1))^2
b = c(1:(nn - 1))^2
C = c(b[1], a[1:(nn - 2)] + b[2:(nn - 1)], a[nn - 1] + nn^2)
Q = tridiag(b, a, -C)
zstart = 6
thomas.tri.sol(Q, z=zstart, v=rep(1,dim(Q)[1]))
}
