% Generated by roxygen2 (4.0.2): do not edit by hand
\name{control.mcmc.MCML}
\alias{control.mcmc.MCML}
\title{Control settings for the MCMC algorithm used for classical inference on a binomial logistic model}
\usage{
control.mcmc.MCML(n.sim, burnin, thin = 1, h, c1.h = 0.01, c2.h = 1e-04)
}
\arguments{
\item{n.sim}{number of simulations.}

\item{burnin}{length of the burn-in period.}

\item{thin}{only every \code{thin} iterations, a sample is stored; default is \code{thin=1}.}

\item{h}{tuning parameter of the proposal distribution; default is \code{h=0.05}.}

\item{c1.h}{value of \eqn{c_{1}} used in the adaptive scheme for \code{h}; default is \code{c1.h=0.01}. See also 'Details' in \code{\link{binomial.logistic.MCML}}}

\item{c2.h}{value of \eqn{c_{2}} used in the adaptive scheme for \code{h}; default is \code{c1.h=0.01}. See also 'Details' in \code{\link{binomial.logistic.MCML}}}
}
\value{
A list with processed arguments to be passed to the main function.
}
\description{
This function defines the options for the MCMC algorithm used in the Monte Carlo maximum likelihood method.
}
\examples{
control.mcmc <- control.mcmc.MCML(n.sim=1000,burnin=100,thin=1,h=0.05)
str(control.mcmc)
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}

