% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cosponsors_specific_bill.R
\name{get_cosponsors_specific_bill}
\alias{get_cosponsors_specific_bill}
\title{Get Cosponsors for a Specific Bill}
\usage{
get_cosponsors_specific_bill(congress, bill_id, myAPI_Key)
}
\arguments{
\item{congress}{105-115}

\item{bill_id}{a bill slug, for example hr4881 - these can be found in the recent bill response.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves information about the cosponsors of a particular bill
}
\description{
HTTP Request: GET https://api.propublica.org/congress/v1/{congress}/bills/{bill-id}/cosponsors.json. Use this request type to get Library of Congress-assigned subjects about a particular bill.
}
\examples{
\donttest{
get_cosponsors_specific_bill(114, 'hr4249')
}
}
