% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recent_bills_by_subject.R
\name{recent_bills_by_subject}
\alias{recent_bills_by_subject}
\title{Get Recent Bills by a Specific Subject}
\usage{
recent_bills_by_subject(subject, page = 1, myAPI_Key)
}
\arguments{
\item{subject}{A slug version of a legislative subject, displayed as url_name in subject responses.}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recently updated bills for a specific legislative subject.
}
\description{
Use this request type to get the 20 most recently updated bills for a specific legislative subject. Results can include more than one Congress. HTTP Request: GET https://api.propublica.org/congress/v1/bills/subjects/{subject}.json
}
\examples{
\donttest{
recent_bills_by_subject('meat')
}
}
