% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registerDatabaseFunctions.R
\name{downloadDatabase}
\alias{downloadDatabase}
\title{Downloads the PROFOUND database}
\usage{
downloadDatabase(location = NULL)
}
\arguments{
\item{location}{file system location to store the database. If not provide, the function will use the current working directory.}
}
\value{
a string with the location of the sql database
}
\description{
This function downloads the PROFOUND database
}
\details{
This is a convenience function to quickly download the PROFOUND database. The function will query you to ask about the path to store the databse, and will return a string with the location, for use in setDB
}
\examples{
\dontrun{
  
# For downloading the data, use 
dbfile <- downloadDatabase(location = tempdir())

# Set the connection using the setDB function
setDB(dbfile)

# check if database is available
getDB()
}
}
\seealso{
\code{\link{getDB}}, \code{\link{setDB}}
}
\author{
Florian Hartig
}
