% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeData.R
\name{summarizeData}
\alias{summarizeData}
\title{A function to summarize data from the database}
\usage{
summarizeData(
  dataset,
  site,
  location = NULL,
  forcingDataset = NULL,
  forcingCondition = NULL,
  by = "year",
  period = NULL,
  mode = "data"
)
}
\arguments{
\item{dataset}{a character string providing the name of a climatic dataset
(CLIMATE_LOCAL, CLIMATE_ISIMIP, ...) or the tree dataset.(change this you )}

\item{site}{a character string providing the name of a site.}

\item{location}{deprecated argument. Please use site instead.}

\item{forcingDataset}{a character string providing the name of a forcingDataset.
Only relevant for ISIMIP datasets.}

\item{forcingCondition}{a character string providing the name of a forcingCondition.
Only relevant for ISIMIP datasets.}

\item{by}{a character string indicating how to summarize the data. Currently supports
by year and total. The latter refers to the entire available period.}

\item{period}{a character array with either start or start and end of the subset.
It must have the format "YYYY-MM-DD", or c("YYYY-MM-DD", "YYYY-MM-DD").}

\item{mode}{a character string indicating whether to display the data summary (data) or an overview (overview).}
}
\value{
a data frame with the summary values
}
\description{
This function allows to summarize datasets for a site
from the PROFOUND database.
}
\details{
This function is under development and has limited functionality. At the
moment, it is possible to summarize daily climate datasets and tree data.

Data are summarized by years. Radiation and precipitation are provided as total yearly
values, while the rest of climatic values are year mean values.  For ISIMIP datasets a summary for whole
period will be returned if the dataset comprises more than one forcing dataset and one forcing condition.
}
\note{
To report errors in the package or the data, please use the issue tracker
in the GitHub repository of ProfoundData \url{https://github.com/COST-FP1304-PROFOUND/ProfoundData}
}
\section{Summary values}{
 Summary is calculated by year
\itemize{
  \item Climatic datasets
  \itemize{
   \item  p_mm and rad_Jcm2day are total yearly values
   \item  tmax_degC,  tmean_degC, tmin_degC, relhum_percent, airpress_hPa  and wind_ms are mean yearly values
   }
  \item TREE dataset
   \itemize{
   \item density_treeha is the number of tree per ha
   \item dbhArit_cm is the arithmetic mean diameter
   \item dbhBa_cm is the average diameter weighted by basal area calculated as dbhBA = (ba1*dbh1 + ba2*dbh2 + ... + bak*dbhk) / (ba1 + ba2+ ... + bak), where bai and dbhi are the basal area and dbh, respectively, of the tree i, and  i = 1, 2, . . , k
   \item dbhDQ_cm is the mean squared diameter or quadratic mean diameter calculated as dbhDQ = sqrt( (dbh1^2 + dbh2^2+ ... + dbhk^2) / N),  where dbhi is the diameter at breast height of tree i,   i = 1, 2, . . , k, N is the total number of trees, and sqrt is the square root
   \item heightArith_m is the arithmetic mean height
   \item heightArith_m is the average height weighted by basal area or Loreys height calculated as heightBA = (ba1*h1 + ba2*h2 + ... + bak*hk) / (ba1 + ba2+ ... + bak), where bai and hi are the basal area and height, respectively, of the tree i, and  i = 1, 2, . . , k
   \item heightBA_m
   \item ba_m2 is the basal area per hectare
   }
}
}

\examples{
# example requires that a sql DB is registered via setDB(dbfile)
# when run without a registered DB, you will get a file query (depending on OS)

\dontrun{
# Summarize by years
data <-summarizeData(dataset =  "TREE", site = "bily_kriz", by = "year",
                     mode = "data")
data <-summarizeData(dataset =  "CLIMATE_LOCAL", site = "bily_kriz", by = "year",
                     mode = "data")
data <-summarizeData(dataset =  "CLIMATE_ISIMIP2A", site = "bily_kriz", by = "year",
                     mode = "data")

# Specify forcing dataset or condition
data <-summarizeData(dataset ="CLIMATE_ISIMIP2B", site ="soro",
                     forcingDataset="GFDLESM2M", forcingCondition ="rcp2p6")


# Summarize total period
data <-summarizeData(dataset =  "TREE", site = "bily_kriz", by = "total",
                     mode = "data")
data <-summarizeData(dataset =  "CLIMATE_LOCAL", site = "bily_kriz", by = "total",
                     mode = "data")

# Summarize overview
data <-summarizeData(dataset =  "CLIMATE_LOCAL", site = "bily_kriz", mode = "overview")
data <-summarizeData(dataset =  "FLUX", site = "bily_kriz", mode = "overview")
data <-summarizeData(dataset =  "TREE", site = "bily_kriz", mode = "overview")
data <-summarizeData(dataset =  "STAND", site = "bily_kriz", mode = "overview")
}
}
\keyword{ProfoundData}
