% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PsychWordVec.R
\name{data_wordvec_subset}
\alias{data_wordvec_subset}
\title{Extract a subset of word vectors data.}
\usage{
data_wordvec_subset(
  x,
  words = NULL,
  pattern = NULL,
  file.save,
  compress = "bzip2",
  compress.level = 9,
  verbose = TRUE
)
}
\arguments{
\item{x}{Can be one of the following:
\itemize{
  \item{a \code{data.table} (of new class \code{wordvec}) loaded by \code{\link{data_wordvec_load}}}
  \item{an .RData file transformed by \code{\link{data_transform}}}
}}

\item{words}{[Option 1] Word strings (\code{NULL}; a single word; a vector of words).}

\item{pattern}{[Option 2] Pattern of regular expression (see \code{\link[stringr:str_subset]{str_subset}}).}

\item{file.save}{File name of to-be-saved R data (must be .RData).}

\item{compress}{Compression method for the saved file. Defaults to \code{"bzip2"}.

Options include:
\itemize{
  \item \code{1} or \code{"gzip"}: modest file size (fastest)
  \item \code{2} or \code{"bzip2"}: small file size (fast)
  \item \code{3} or \code{"xz"}: minimized file size (slow)
}}

\item{compress.level}{Compression level from \code{0} (none) to \code{9}
(maximal compression for minimal file size). Defaults to \code{9}.}

\item{verbose}{Print information to the console? Defaults to \code{TRUE}.}
}
\value{
A subset of word vectors data of valid (available) words.
}
\description{
Extract a subset of word vectors data.
You may specify either a \code{data.table} loaded by \code{\link{data_wordvec_load}})
or an .RData file transformed by \code{\link{data_transform}}).
}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
## specify `x` as a data.table:
d = data_wordvec_subset(demodata, c("China", "Japan", "Korea"))
d

## specify `x` and `pattern`, and save with `file.save`:
data_wordvec_subset(demodata, pattern="Chin[ae]|Japan|Korea",
                    file.save="subset.RData")

## load the subset:
d.subset = data_wordvec_load("subset.RData")
d.subset

## specify `x` as an .RData file and save with `file.save`:
data_wordvec_subset("subset.RData",
                    words=c("China", "Chinese"),
                    file.save="new.subset.RData")
d.new.subset = data_wordvec_load("new.subset.RData")
d.new.subset

unlink("subset.RData")  # delete file for code check
unlink("new.subset.RData")  # delete file for code check

}
\seealso{
\code{\link{data_transform}}

\code{\link{data_wordvec_load}}

\code{\link{data_wordvec_normalize}}

\code{\link{data_wordvec_reshape}}
}
