% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWV1_static.R
\name{data_wordvec_load}
\alias{data_wordvec_load}
\title{Load word vectors data (\code{wordvec} or \code{embed}) from ".RData" file.}
\usage{
data_wordvec_load(
  file.load,
  as = c("wordvec", "embed"),
  normalize = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{file.load}{File name (must be .RData transformed by
\code{\link{data_transform}}).}

\item{as}{Load as
\code{\link[PsychWordVec:as_wordvec]{wordvec}} (data.table) or
\code{\link[PsychWordVec:as_embed]{embed}} (matrix).
Defaults to the original class of the R object in \code{file.load}.}

\item{normalize}{Normalize all word vectors to unit length?
Defaults to \code{FALSE}. See \code{\link{data_wordvec_normalize}}.}

\item{verbose}{Print information to the console? Defaults to \code{TRUE}.}
}
\value{
A \code{wordvec} (data.table) or \code{embed} (matrix).
}
\description{
Load word vectors data (\code{wordvec} or \code{embed}) from ".RData" file.
}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
\dontrun{
# please first manually download the .RData file
# (see https://psychbruce.github.io/WordVector_RData.pdf)
# or transform plain text data by using `data_transform()`

# the RData file must be on your disk
# the following code cannot run unless you have the file
library(bruceR)
set.wd()
d = data_wordvec_load("GloVe/glove_wiki_50d.RData")
}

}
\seealso{
\code{\link{as_wordvec}} / \code{\link{as_embed}}

\code{\link{data_transform}}

\code{\link{data_wordvec_normalize}}

\code{\link{data_wordvec_subset}}
}
