% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_funds_map.R
\name{plot_funds_map}
\alias{plot_funds_map}
\title{Visual representation by mapping municipalities' polygons and color-coding them according to financial expenditures.}
\usage{
plot_funds_map(data, var)
}
\arguments{
\item{data}{dataset of class 'data.frame'.
Specify the dataset from which to take information. The dataset must contain the geometry of the polygons of each municipality.}

\item{var}{character. Specify the name of the variable to visualize.}
}
\value{
Return \code{ggplot} object representing an interactive map.
}
\description{
The \code{plot_funds_map} function is designed for visualizing areal data within a region. It generates an informative map where each municipality is represented with a unique color determined by its corresponding financing amount.
}
\examples{
#Retrieve data with the polygons of the municipalities
RENDISarea <- get_data_RENDIS("12", geo_ref = "A")
plot_funds_map(RENDISarea, var = "Finance")

#Plotting the map for Lazio region to visualize the total public
#expenditure divided by municipality.

}
\author{
Lorena Ricciotti
}
