% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional_data.R
\name{run_functional_t_test}
\alias{run_functional_t_test}
\title{Run a functional t-test on a dataframe previously fitted with b-splines.}
\usage{
run_functional_t_test(data, pupil, alpha = 0.05)
}
\arguments{
\item{data}{a Pupil_difference_data fitted with b-splines}

\item{pupil}{column name indicating pupil data to test}

\item{alpha}{an alpha level to be set for the t-test}
}
\value{
A Pupil_test_data dataframe
}
\description{
This allows running of a functional t-test for a given alpha on pupil data that has been fitted with b-splines.
This is only appropriate for functional difference data, as it assumes we are dealing with condition A - condition B.
}
\examples{
Sdata <- make_pupillometryr_data(data = pupil_data,
                               subject = ID,
                               trial = Trial,
                               time = Time,
                               condition = Type)
regressed_data <- regress_data(data = Sdata, pupil1 = RPupil, pupil2 = LPupil)
mean_data <- calculate_mean_pupil_size(data = regressed_data, pupil1 = RPupil, pupil2 = LPupil)
base_data <- baseline_data(data = mean_data, pupil = mean_pupil, start = 0, stop = 100)
differences <- create_difference_data(data = base_data, pupil = mean_pupil)
spline_data <- create_functional_data(data = differences, pupil = mean_pupil, basis = 10, order = 4)
ft_data <- run_functional_t_test(data = spline_data, pupil = mean_pupil, alpha = 0.05)

}
