% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pupil_data.R
\name{plot.Pupil_difference_data}
\alias{plot.Pupil_difference_data}
\title{Pre-prepared plots of PupillometryR data}
\usage{
\method{plot}{Pupil_difference_data}(x, pupil, geom = c("point", "line"),
  colour = "black", ...)
}
\arguments{
\item{x}{A Pupil_difference_data dataframe}

\item{pupil}{Column name of pupil data to be plotted}

\item{geom}{string indicating whether made of connected points or a line}

\item{colour}{string indicating colour of geom, passed to ggplot2}

\item{...}{Ignored}
}
\value{
A ggplot object
}
\description{
The plot functions are designed to run with just data and pupil selections,
with some additional options for fun with plotting. To see these plots,
you must first use create_difference_data.
}
\examples{
Sdata <- make_pupillometryr_data(data = pupil_data,
                               subject = ID,
                               trial = Trial,
                               time = Time,
                               condition = Type)
regressed_data <- regress_data(data = Sdata, pupil1 = RPupil, pupil2 = LPupil)
mean_data <- calculate_mean_pupil_size(data = regressed_data,
pupil1 = RPupil, pupil2 = LPupil)
base_data <- baseline_data(data = mean_data, pupil = mean_pupil, start = 0, stop = 100)
differences <- create_difference_data(data = base_data,
pupil = mean_pupil)
p <- plot(differences, pupil = mean_pupil, geom = 'line')
p
}
