% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pupil_data.R
\name{plot.PupillometryR}
\alias{plot.PupillometryR}
\title{Pre-prepared plots of PupillometryR data}
\usage{
\method{plot}{PupillometryR}(x, pupil, group = c("none", "condition", "subject"), model = NULL, ...)
}
\arguments{
\item{x}{A PupillometryR dataframe}

\item{pupil}{Column name of pupil data to be plotted}

\item{group}{What to group the data by (none, condition, or subject)}

\item{model}{Optional argument to plot agains a fitted model}

\item{...}{Ignored}
}
\value{
A ggplot object
}
\description{
The plot functions are designed to run with just data and pupil selections,
with some additional options for fun with plotting. This allows to see
raw data as points, grouped by either subject or condition.
}
\examples{
Sdata <- make_pupillometryr_data(data = pupil_data,
subject = ID,
trial = Trial,
time = Time,
condition = Type)
Sdata2 <- downsample_time_data(data = Sdata,
pupil = LPupil,
timebin_size = 100,
option = 'median')
p <- plot(Sdata2, pupil = LPupil, group = 'subject')
p

}
