% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sensor_data.R
\name{get_sensor_data}
\alias{get_sensor_data}
\title{Get Sensor Data}
\usage{
get_sensor_data(
  sensor_index,
  fields,
  purple_air_api_key = Sys.getenv("PURPLE_AIR_API_KEY"),
  read_key = NULL
)
}
\arguments{
\item{sensor_index}{Integer (or numeric, character object coerceable to integer) \code{sensor_index}}

\item{fields}{A character vector of which 'sensor data fields' to return}

\item{purple_air_api_key}{A character that is your PurpleAir API \code{READ} key}

\item{read_key}{A character key required to read data from private devices}
}
\value{
A list of sensor data, named by the provided \code{fields}
}
\description{
Retrieves the latest data of a single sensor matching the provided \code{sensor_index}.
Find more details on sensor fields at https://api.purpleair.com/#api-sensors-get-sensor-data.
}
\examples{
\dontrun{
get_sensor_data(sensor_index = 175413, fields = c("name", "last_seen", "pm2.5_cf_1", "pm2.5_atm"))
get_sensor_data(sensor_index = "175413", fields = c("name", "last_seen", "pm2.5_cf_1", "pm2.5_atm"))
}
}
\seealso{
get_sensors_data get_sensor_history
}
