% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http.R
\name{brapi_headers}
\alias{brapi_headers}
\title{Generate Common HTTP Headers for API Requests}
\usage{
brapi_headers()
}
\value{
A named list of common HTTP headers, including the authorization token (Bearer), 
content encoding, and accepted content types.

A named list containing key HTTP headers, including:
\itemize{
  \item \strong{Authorization:} Bearer token used for authenticated API access.
  \item \strong{Accept-Encoding:} Specifies supported compression types such as gzip and deflate.
  \item \strong{Accept:} Specifies that the client accepts responses in JSON format.
}
}
\description{
This function constructs a list of standard HTTP headers required for making API 
requests, ensuring proper authentication and encoding. These headers are typically 
included with each API call to provide necessary information such as authorization 
tokens and content acceptance types. The function is designed to work with 
authenticated APIs, including BrAPI.
}
\note{
Ensure that the global state contains a valid authorization token before making API 
requests. This function retrieves the token from `qbms_globals$state$token`, which 
should be set after a successful login or authentication process.
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
