\name{Osa}

\docType{data}

\alias{Osa}

\title{Political Opportunity in Non-democracies}

\description{
The \bold{Osa} data frame has 24 rows and 6 columns.

This data is drawn from a study which analyzes twenty-four cases of occurrence/non-occurrence of 
mobilization in non-democratic states to determine conditions of political opportunity in 
high-risk authoritarian contexts. Political opportunity is sensitive to conditions created by 
divided elites, changes in repression, media access, influential allies, and social networks
}

\usage{data(Osa)}

\format{
The dataset contains the following columns:
\tabular{ll}{
DYNA \tab Dynamics of repression, coded 1 for evidence of increase in long-term and/or short-term \cr
     \tab state repression, 0 for evidence of decrease \cr
ACCESS \tab Media access - coded 1 if the public information flow concerning a particular event \cr
       \tab of popular mobilization is controlled by the political authorities (via censorship \cr
       \tab or ban on foreign media), 0 if there was evidence of sustained relaxation of state \cr
       \tab censorship or substantive presence of foreign and/or underground media \cr
INFLU \tab Influential allies - coded 1 for presence of domestic or foreign politically \cr
      \tab influential groups supporting popular mobilization; 0 for absence of such \cr
      \tab organizational support \cr
ELITE \tab Division of elites, coded 1 - evidence of competing factions within the ruling elites; \cr
      \tab 0 - relatively unified ruling group \cr
SOCIAL \tab Social networks - coded 1if mobilization resulted from the activity of interconnected \cr
       \tab groups, 0 if organizational and/or individual ties were severely destroyed or impeded \cr
       \tab to emerge by the state \cr
OUT \tab Social mobilization, coded 1 for major episodes of sustained collective action \cr
    \tab opposing state policies by participants drawn from nonelite or repressed segments \cr
    \tab of society in non-democratic regimes, 0 - non-mobilization
}
}

\source{\url{http://www.compasss.org}}

\references{
Osa, Maryjane and Corduneanu-Huci, Cristina 2003 \emph{Running Uphill: Political Opportunity
in Non-democracies}, Comparative Sociology 2(4), pp. 605-629(25)
}

\keyword{datasets}
