% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/summary.fsQCApt.R
\name{summary.fsQCApt}
\alias{summary.fsQCApt}
\title{Summarize Permutation Tests for fsQCA Data}
\usage{
\method{summary}{fsQCApt}(object, ...)
}
\arguments{
\item{object}{Object returned by \code{\link{fsQCApermTest}}.}

\item{...}{Additional parameters to pass on.}
}
\value{
Two matrices of values for counterexamples and consistency.
}
\description{
Displays observed values, confidence intervals, and raw and adjusted p-scores for both consistency and counterexamples following permutation test of fsQCA data.
}
\examples{
data(social.revolutions)
attach(social.revolutions)

intersect <- pmin(breakdown, pop.ins)
intersect2 <- pmin(breakdown, (1-pop.ins))
intersect3 <- pmin((1-breakdown), pop.ins)
intersect4 <- pmin((1-breakdown), (1-pop.ins))

test <- fsQCApermTest(y=soc.rev, configs=list(BI=intersect, Bi=intersect2,
   bI=intersect3, bi=intersect4), total.configs=4)
summary(test)
}
\keyword{fsQCA}
\keyword{permutation}
\keyword{test}

