% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All_Simplified_MUFASA_Code.R
\name{p.MLE}
\alias{p.MLE}
\title{Returns simplified MLE diet estimates corresponding to a sample of predators.}
\usage{
p.MLE(pred.mat, prey.mat, cal.mat, FC, ext.fa)
}
\arguments{
\item{pred.mat}{matrix containing the FA signatures of the predators.}

\item{prey.mat}{matrix containing the FA signatures of the individual prey.
The first column must index the prey group.
\emph{prey.mat} is the prey database.}

\item{cal.mat}{matrix of calibration factors where the \emph{i} th
column is to be used with the \emph{i} th predator. If modelling is to be
done without calibration coefficients, simply pass a vector or matrix of
ones.}

\item{FC}{vector of fat content of length equal to the number of prey groups
or species.}

\item{ext.fa}{subset of fatty acids to be used to obtain diet estimates.}
}
\value{
A list with components:
\item{Diet_Estimates}{A matrix of the diet estimates for each predator where
each row corresponds to a predator and the columns to prey species.
The estimates are expressed as proportions summing to one.}
\item{Var_Epsilon}{Optimized values of error variance.  See reference.}
\item{nll}{Negative log likelihood values.  As per \emph{solnp} documentation,
           \emph{nll} is a "vector of function values during optimization
 with last one the value at the optimal".}
}
\description{
Computes the diet estimate for each predator in \emph{pred.mat} using the
simplified MLE method, without the use of random effects.
}
\details{
The assumed model is similar to the MUFASA model but the random
effects are replaced by the prey species' sample means to speed up
computations. Unlike \emph{p.MUFASA}, this function does not require
integration and hence is much faster.
}
\examples{

##  This example takes some time to run.
## Please uncomment the code below to run.


#library(dplyr)
#library(compositions)

## Fatty Acids
#data(FAset)
#ext.fa <- as.vector(unlist(FAset))

## Predators
#data(predatorFAs)
#pred.mat <- predatorFAs[, -c(1:4)]
#n.pred <- nrow(pred.mat)

## Prey
#data(preyFAs)
#prey.mat <- preyFAs[, -c(1,3)]

#FC = preyFAs[,c(2,3)]
#FC = as.vector(tapply(FC$lipid,FC$Species,mean,na.rm=TRUE))

## Calibration Coefficients
#data(CC)
#cal.vec = CC[,2]
#cal.mat = replicate(n.pred, cal.vec)
#rownames(cal.mat) <- CC$FA


## Diet Estimates
#mle.est <- p.MLE(pred.mat, prey.mat, cal.mat, FC, ext.fa)
#mle.est$"Diet Estimates"
}
\references{
Steeves, Holly (2020) Maximum likelihood approach to diet
estimation and inference based on fatty acid signatures. PhD thesis available
at https://dalspace.library.dal.ca/handle/10222/80034.
}
