% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simultaneous_Estimation_of_CCs.R
\name{p.sim.QFASA}
\alias{p.sim.QFASA}
\title{Simultaneous estimation of diet composition and calibration coefficients}
\usage{
p.sim.QFASA(pred.sig, prey.mat, FC = rep(1, nrow(prey.mat)))
}
\arguments{
\item{pred.sig}{matrix containing the FA signatures of the predator}

\item{prey.mat}{matrix containing a representative FA signature from each
prey group (usually the mean).  The first column must index
the prey group.}

\item{FC}{vector of fat content of length equal to the number of prey groups
(or species)}
}
\value{
A list with components:
\item{diet.est}{A matrix of the diet estimates for each predator where each
row corresponds to a predator and the columns to prey species. The estimates
are expressed as proportions summing to one.}
\item{cc.est}{Estimated vector of calibration coefficients}
}
\description{
Computes the diet estimate for each predator in \emph{pred.sig} as well as an
overall estimate of the calibration coefficient vector.
}
\details{
Starting values for the diet estimates are equal proportions
          and a vector of ones is used for the calibration coefficients.
}
\examples{

##  This example takes some time to run.
## Please uncomment code below to run.

## Fatty Acids
#data(FAset)
#fa.set = as.vector(unlist(FAset))

## Predators
#data(predatorFAs)
#tombstone.info = predatorFAs[,1:4]
#predator.matrix = predatorFAs[,5:(ncol(predatorFAs))]
#npredators = nrow(predator.matrix)

## Need predator and prey to have same length

#predator.ext <- predator.matrix[fa.set]
#predator.ext <- predator.ext/rowSums(predator.ext)

## Prey
#data(preyFAs)
#prey.sub=(preyFAs[,4:(ncol(preyFAs))])[fa.set]
#prey.sub=prey.sub/apply(prey.sub,1,sum)
#group=as.vector(preyFAs$Species)
#prey.matrix=cbind(group,prey.sub)
#prey.matrix=MEANmeth(prey.matrix)

## Fat Content
#FC = preyFAs[,c(2,3)]
#FC = as.vector(tapply(FC$lipid,FC$Species,mean,na.rm=TRUE))

#Q.sim <-p.sim.QFASA(predator.ext,prey.matrix,FC)
## Average Diet Estimate
#round(colMeans(Q.sim[[1]]),3)
## Calibration Coefficients
#Q.sim[[2]]
}
\references{
Bromaghin, Jeffrey F., Budge, Suzanne M.,  Thiemann, Gregory and
Rode, Karyn D. (2017) Simultaneous estimation of the diet composition and
calibration coefficients with fatty acid signature data.
Ecology and Evolution, 7(16), 6103-6113
}
