% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/res.surface.R
\name{res.surface}
\alias{res.surface}
\title{Compute Critical Values for the DQ test using a Response Surface}
\usage{
res.surface(p, l, q.L, q.R, d.Sym)
}
\arguments{
\item{p}{The number of parameters in the model.}

\item{l}{The number of breaks under the null \eqn{H_0} (i.e., \eqn{l+1} under \eqn{H_1}).}

\item{q.L}{The lower bound of the quantile range.}

\item{q.R}{The upper bound of the quantile range (not used in the function because \eqn{q.R=1-q.L}).}

\item{d.Sym}{A logical value. Must be TRUE, as this method applies only to symmetric trimming (\eqn{q.R=1-q.L}).}
}
\value{
A numeric vector of length 3 containing critical values at the 10\%, 5\%, and 1\% significance levels.
}
\description{
This function returns critical values obtained from a response surface analysis.
Note that this procedure only applies when the trimming is symmetric, i.e., \eqn{q.R=1-q.L}.
}
\examples{
# The number of regerssors 
p = 5 
## The number of breaks under the null 
l = 2 

# qunatile range (left and right limits)
q.L = 0.2
q.R = 0.8 

# symmetric quantile trimming is true 
d.Sym = TRUE 

## critical values from response surface 
cvs = res.surface(p, l, q.L, q.R, d.Sym)

print(cvs)

}
