% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QUALYPSO.r
\name{fit.climate.response}
\alias{fit.climate.response}
\title{fit.climate.response}
\usage{
fit.climate.response(Y, args.smooth.spline, Xmat, Xfut, typeChangeVariable)
}
\arguments{
\item{Y}{matrix of simulation chains: \code{nS} x \code{nY}}

\item{args.smooth.spline}{list of arguments to be passed to \code{\link[stats]{smooth.spline}}.
The \code{names} attribute of \code{args.smooth.spline} gives the argument
names (see \code{\link[base]{do.call}}).}

\item{Xmat}{matrix of predictors corresponding to the projections, e.g. time or global temperature.}

\item{Xfut}{values of the predictor over which the ANOVA will be applied.}

\item{typeChangeVariable}{type of change variable: "abs" (absolute, value by default) or "rel" (relative)}
}
\value{
list with the following fields for each simulation chain:
\itemize{
  \item \strong{phiStar}: \code{nS x nF}, climate change responses
  \item \strong{etaStar}: \code{nS x nY}, deviation from the climate change response
  due to the internal variability, for \code{Xmat}
  \item \strong{phi}: \code{nS x nF}, raw trends obtained using \link[stats]{smooth.spline}
  \item \strong{climateResponse}: output from \link[stats]{smooth.spline}
  \item \strong{varInterVariability}: scalar, internal variability component of the MME
}
}
\description{
Fit trends for each simulation chain of an ensemble of \code{nS} projections. Each simulation chain is a time series
of \code{nY} time steps (e.g. number of years).
}
\details{
See \code{\link{QUALYPSO}} for further information on arguments \code{indexReferenceYear} and \code{typeChangeVariable}.
}
\references{
Evin, G., B. Hingray, J. Blanchet, N. Eckert, S. Morin, and D. Verfaillie (2020)
Partitioning Uncertainty Components of an Incomplete Ensemble of Climate Projections Using Data Augmentation.
Journal of Climate. J. Climate, 32, 2423–2440. <doi:10.1175/JCLI-D-18-0606.1>.
}
\author{
Guillaume Evin
}
