% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0rpartD.R
\name{rpartD}
\alias{rpartD}
\title{Dichotomize via Recursive Partitioning}
\usage{
rpartD(y, x, ...)
}
\arguments{
\item{y}{a \link[survival]{Surv} object, a \link[base]{logical} \link[base]{vector},
or a \link[base]{numeric} \link[base]{vector}, the endpoint}

\item{x}{\link[base]{numeric} \link[base]{vector}, the predictor}

\item{...}{additional parameters, currently not in use}
}
\value{
\link{rpartD} returns a \link[base]{language} object.
}
\description{
Dichotomize a single \link[base]{numeric} predictor
using recursive partitioning \link[rpart]{rpart}.
}
\details{
The \link[rpart]{labels.rpart} of the first node of
the recursive partitioning \link[rpart]{rpart} tree
is considered as the dichotomizing branch of the \link[base]{numeric} predictor \code{x}.

The term \emph{branch} indicates the combination of an inequality sign
(\link[base]{>}, \link[base]{>=}, \link[base]{<} and \link[base]{<=})
and a \link[base]{numeric} threshold \eqn{a}.

This branch is further processed, such that
\itemize{
\item {\eqn{<a} is returned as \eqn{\geq a}}
\item {\eqn{\leq a} is returned as \eqn{>a}}
\item {\eqn{> a} and \eqn{\geq a} are returned as is.}
}
This step is necessary for a narrative of \emph{higher than the threshold}.
}
\note{
In the recursive partitioning \link[rpart]{rpart} tree, we use the following tuning parameters
in \link[rpart]{rpart.control},
\itemize{
\item {\code{maxdepth = 2L}, because only the first node is needed}
\item {\code{cp = .Machine$double.eps}, so that a split is guaranteed
no matter how small improvement in overall \eqn{R^2} is}
}
}
\examples{
# see ?rpart::rpart examples
data(kyphosis, package = 'rpart')
rpartD(y = kyphosis$Kyphosis, x = kyphosis$Start)
rpartD(y = kyphosis$Kyphosis, x = -kyphosis$Start)

}
