% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Quandldatabase.R
\name{Quandl.database.bulk_download_to_file}
\alias{Quandl.database.bulk_download_to_file}
\title{Downloads a zip with all data from a Quandl database}
\usage{
Quandl.database.bulk_download_to_file(database_code, filename, ...)
}
\arguments{
\item{database_code}{Database code on Quandl specified as a string.}

\item{filename}{Filename (including path) of file to download.}

\item{...}{Additional named values that are interpreted as Quandl API parameters. Please see \url{https://www.quandl.com/docs/api#entire-database} for a full list of parameters.}
}
\value{
The filename of the downloaded file.
}
\description{
Downloads a zip with all data from a Quandl database
}
\details{
Set your \code{api_key} with \code{Quandl.api_key} function. For instructions on finding your api key go to \url{https://www.quandl.com/account/api}
}
\examples{
\dontrun{
Quandl.database.bulk_download_to_file("NSE", "./NSE.zip")
}
}
\seealso{
\code{\link{Quandl.api_key}}
}
