% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StepK_fmx.R
\name{StepK_fmx}
\alias{StepK_fmx}
\title{Forward-Backward Selection of the Number of Components \eqn{K}}
\usage{
StepK_fmx(
  object,
  by = c("logLik", "AIC", "BIC"),
  Kmax = 3L,
  silent = FALSE,
  ...
)
}
\arguments{
\item{object}{\code{'fmx_QLMDe'} object returned from \code{\link{QLMDe}}}

\item{by}{criterion, currently supporting 
\code{'logLik'} (via my \code{\link{LikRatio}}, likelihood ratio test, default and recommended), 
\code{'AIC'} (via \code{\link[stats]{AIC}}) and 
\code{'BIC'} (via \code{\link[stats]{BIC}}).}

\item{Kmax}{'integer' value, the maximum number of component to be considered}

\item{silent}{'logical' value, whether messages should be suppressed (default \code{FALSE})}

\item{...}{additional parameters}
}
\value{
\code{\link{StepK_fmx}} returns an \code{'fmx_QLMDe'} object, with attributes
\itemize{
\item{\code{anova}} {ANOVA table}
\item{\code{objF}} {value of the objective function (either the log-likelihood, AIC or BIC)}
}
}
\description{
The function \code{\link{StepK_fmx}} compares \eqn{gh}-parsimonious models with different number of components \eqn{K}
and selects the optimal model using the Vuong's closeness test.
}
\details{
The algorithm starts with selection \eqn{gh}-parsimonious model with user-specified initial number of components \eqn{K_0}.
Then the number of components is increased by \eqn{1} and the corresponding 
\eqn{gh}-parsimonious model is compared to the \eqn{gh}-parsimonious model with \eqn{K_0} components using the Vuong's closeness test. 
If \eqn{gh}-parsimonious model with \eqn{K_0} components is preferred then the algorithm is stopped if \eqn{K_0=1} 
or switches to backward selection if \eqn{K_0 > 1}.
If \eqn{gh}-parsimonious model with \eqn{K_0 + 1} components is preferred then
the algorithm is stopped if \eqn{K_0+1=Kmax} (prespecified maximum number of components)
or the next iteration of the algorithm is performed if \eqn{K_0+1<Kmax}.
The backward selection is performed only if \eqn{gh}-parsimonious model with \eqn{K_0} components 
is preferred to \eqn{gh}-parsimonious model with \eqn{K_0+1} components. 
Then \eqn{gh}-parsimonious model with \eqn{K_0-1} components is compared to
\eqn{gh}-parsimonious model with \eqn{K_0} components. 
If \eqn{gh}-parsimonious model with \eqn{K_0} components is preferred then the algorithm is stopped
and \eqn{gh}-parsimonious model with \eqn{K_0} components is optimal.
If \eqn{gh}-parsimonious model with \eqn{K_0-1} components is preferred then
the algorithm is stopped if \eqn{K_0-1=1} 
or the next iteration of the algorithm is performed if \eqn{K_0-1>1}.
}
