% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TukeyGH.R
\name{TukeyGH}
\alias{TukeyGH}
\alias{dGH}
\alias{rGH}
\alias{qGH}
\alias{pGH}
\alias{z2qGH}
\alias{qGH2z}
\title{Tukey's \eqn{g}-&-\eqn{h} Distribution}
\usage{
dGH(x, A = 0, B = 1, g = 0, h = 0, log = FALSE, ...)

rGH(n, A = 0, B = 1, g = 0, h = 0)

qGH(p, A = 0, B = 1, g = 0, h = 0, lower.tail = TRUE, log.p = FALSE)

pGH(q, A = 0, B = 1, g = 0, h = 0, lower.tail = TRUE, log.p = FALSE, ...)

z2qGH(z, A = 0, B = 1, g = 0, h = 0)

qGH2z(q, q0 = (q - A)/B, qok = is.finite(q0), A = 0, B = 1, ...)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{A}{location parameter, with default value of 0, as parameter \code{mean} of \code{\link[stats]{dnorm}}}

\item{B}{(>0) scale parameter, with default value of 1, as parameter \code{sd} of \code{\link[stats]{dnorm}}}

\item{g}{skewness parameter}

\item{h}{(>=0) kurtosis parameter}

\item{log, log.p}{logical; if \code{TRUE}, probabilities \eqn{p} are given as \eqn{log(p)}.}

\item{...}{potential parameters}

\item{n}{number of observations, see \code{\link[stats]{rnorm}} for more details.}

\item{p}{vector of probabilities.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{Pr(X\le x)} otherwise, \eqn{Pr(X>x)}.}

\item{z}{standard normal quantiles.}

\item{q0, qok}{parameters for internal use}
}
\value{
\code{\link{dGH}} gives the density and accommodates vector arguments \code{A}, \code{B}, \code{g} and \code{h}.
The quantiles \code{x} can be either vector or matrix.
This function takes about 1/5 time of \code{\link[gk]{dgh}}.

\code{\link{pGH}} gives the distribution function, only taking scalar arguments and vector quantiles \code{q}.
This function takes about 1/10 time of \code{\link[gk]{pgh}} and \code{\link[OpVaR]{pgh}}.

\code{\link{qGH}} gives the quantile function, only taking scalar arguments and vector probabilities \code{p}.
This function takes about 1/2 time of \code{\link[gk]{qgh}} and 1/10 time of \code{\link[OpVaR]{qgh}}.

\code{\link{rGH}} generates random deviates, only taking scalar arguments.

\code{\link{z2qGH}} is the Tukey's \eqn{g}-&-\eqn{h} transformation.
Note that \code{gk:::z2gh} is only an \strong{approximation} to Tukey's \eqn{g}-&-\eqn{h} transformation.

Unfortunately, the inverse of Tukey's \eqn{g}-&-\eqn{h} transformation, \code{\link{qGH2z}}, does not have a closed form.
We make use of the numerical solution provided in \code{\link[rstpm2]{vuniroot}}.
This function takes scalar arguments and vector quantiles \code{q}.
The computation cost of \code{\link{qGH2z}} is considerable, 
as we need to solve the Tukey's \eqn{g}-&-\eqn{h} transformation for each quantile provided.
}
\description{
Density, distribution function, quantile function and random generation 
for the Tukey's \eqn{g}-&-\eqn{h} distribution with 
location parameter \code{A},
scale parameter \code{B},
skewness \code{g} and 
kurtosis \code{h}.
}
\details{
..
}
\examples{

(x = c(NA_real_, rGH(n = 5L, g = .3, h = .1)))
dGH(x, g = c(0,.1,.2), h = c(.1,.1,.1))

p0 = seq.int(0, 1, by = .2)
(q0 = qGH(p0, g = .2, h = .1))
range(pGH(q0, g = .2, h = .1) - p0)

q = (-2):3; q[2L] = NA_real_; q
(p1 = pGH(q, g = .3, h = .1))
range(qGH(p1, g = .3, h = .1) - q, na.rm = TRUE)
(p2 = pGH(q, g = .2, h = 0))
range(qGH(p2, g = .2, h = 0) - q, na.rm = TRUE)

curve(dGH(x, g = .3, h = .1), from = -2.5, to = 3.5)

}
