% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clust_fmx.R
\name{clust_fmx}
\alias{clust_fmx}
\title{Estimates of Finite Mixture Distribution (\code{linkS4class{fmx}}) via Clustering}
\usage{
clust_fmx(x, distname, K, constraint = character())
}
\arguments{
\item{x}{\code{\link[base]{numeric}} vector of observations}

\item{distname}{\code{\link[base]{character}} value for the name of parametric distribution}

\item{K}{\code{\link[base]{integer}} value of the number of components}

\item{constraint}{see \code{\link{QLMDe}}}
}
\value{
An S4 \code{\linkS4class{fmx}} object fitted on given observations, using trimmed \eqn{k}-means clustering with re-assignment,
and cluster-wise robust parameter estimates.
}
\description{
First, trimmed \eqn{k}-means clustering with re-assignment is used to assign all trimmed observations 
back to one of the \eqn{K} components, 
then for each component, robust parameter estimates are computed for each 
mixture component using only observations from the corresponding cluster.
}
\details{
The naive estimates for the mixture distribution is obtained in the following two steps.

\itemize{

\item {Trimmed \eqn{k}-means clustering (\code{\link[tclust]{tkmeans}}) with re-assignment. 
First, \eqn{5\%} (default value of parameter \code{alpha} of \code{\link[tclust]{tkmeans}}) 
of observations are trimmed and \eqn{k}-mean clustering is performed.
Next, the \code{\link[stats]{mahalanobis}} distance is computed between each trimmed observation and each cluster.
Then, each trimmed observation is assigned to the closest cluster (at the smallest Mahalanobis distance). 
The standard \eqn{k}-means clustering (\code{\link[stats]{kmeans}}) is not used since the heavy tails of 
Tukey's \eqn{g}-&-\eqn{h} distribution can be mistakenly classified as a cluster.}

\item {In each cluster, the following estimates are computed, 
(i). median and median absolute deviation (\code{\link[stats]{mad}}) for individual normal component;
(ii). Letter-based estimates for individual Tukey's \eqn{g}-&-\eqn{h} components.}

\item {The mixing probability of each component is estimated by the proportion of observations 
in the corresponding cluster.}

}
}
\examples{
d1 = fmx('norm', mean = c(1, 2), sd = .5, w = c(.4, .6))
set.seed(100); hist(x1 <- rfmx(n = 1e3L, dist = d1))
clust_fmx(x1, distname = 'norm', K = 2L)

(d2 = fmx('GH', A = c(1,6), B = 2, g = c(0,.3), h = c(.2,0), w = c(1,2)))
set.seed(100); hist(x2 <- rfmx(n = 1e3L, dist = d2))
clust_fmx(x2, distname = 'GH', K = 2L)
clust_fmx(x2, distname = 'GH', K = 2L, constraint = c('g1', 'h2'))

}
\references{
David C. Hoaglin (2006)  Summarizing Shape Numerically: The \eqn{g}-and-\eqn{h} Distributions. 
Wiley Series in Probability and Statistics. Chapter 11.  \doi{10.1002/9781118150702.ch11}
}
