% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0Int_base_stats.R
\name{crossprod_inv}
\alias{crossprod_inv}
\title{Inverse of \eqn{X'X} by QR Decomposition}
\usage{
crossprod_inv(X)
}
\arguments{
\item{X}{\eqn{m*n} \code{\link[base]{matrix}}}
}
\value{
The inverse \code{\link[base]{matrix}} of the cross product \eqn{(X'X)}, where \eqn{X} is the input \code{\link[base]{matrix}}.
}
\description{
Compute \eqn{(X'X)^{-1}} from the R part of the QR decomposition of \eqn{X}.
}
\examples{
set.seed(123); (X = array(rnorm(40L), dim = c(8L, 5L)))
stopifnot(all.equal.numeric(solve(crossprod(X)), crossprod_inv(X)))


}
\references{
\url{https://en.wikipedia.org/wiki/QR_decomposition}, section \strong{Rectangular matrix}
}
\seealso{
\code{\link[base]{chol2inv}}, \code{\link[base]{chol.default}}
}
