% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlogis.R
\name{mlogis}
\alias{mlogis}
\alias{qmlogis_first}
\alias{qmlogis_last}
\alias{pmlogis_first}
\alias{pmlogis_last}
\title{Transformation between Multinomial Probabilities & Logits}
\usage{
qmlogis_first(p)

qmlogis_last(p)

pmlogis_first(q)

pmlogis_last(q)
}
\arguments{
\item{p}{\code{\link[base]{numeric}} vector of multinomial probabilities, adding up to 1}

\item{q}{\code{\link[base]{numeric}} vector of multinomial logits}
}
\value{
\code{\link{pmlogis_first}} and \code{\link{pmlogis_last}} return a vector of multinomial probabilities.

\code{\link{qmlogis_first}} and \code{\link{qmlogis_last}} returns a vector of multinomial logits, regarding the first or last category 
as reference, respectively.
}
\description{
Performs transformation between vectors of multinomial probabilities and multinomial logits.

This transformation is a generalization of \code{\link[stats]{plogis}} which converts scalar logit into probability
and \code{\link[stats]{qlogis}} which converts probability into scalar logit.
}
\details{
\code{\link{pmlogis_first}} and \code{\link{pmlogis_last}} take a length \eqn{k-1} \code{\link[base]{numeric}} vector of 
multinomial logits and convert them into length \eqn{k} multinomial probabilities, regarding the first or last category 
as reference, respectively.

\code{\link{qmlogis_first}} and \code{\link{qmlogis_last}} take a length \eqn{k} \code{\link[base]{numeric}} vector of 
multinomial probabilities and convert them into length \eqn{k-1} multinomial logits, regarding the first or last category 
as reference, respectively.
}
\examples{
(a = qmlogis_last(c(2,5,3)))
(b = qmlogis_first(c(2,5,3)))
pmlogis_last(a)
pmlogis_first(b)

q0 = .8300964
(p1 = pmlogis_last(q0))
(q1 = qmlogis_last(p1))

# various exceptions
pmlogis_first(qmlogis_first(c(1, 0)))
pmlogis_first(qmlogis_first(c(0, 1)))
pmlogis_first(qmlogis_first(c(0, 0, 1)))
pmlogis_first(qmlogis_first(c(0, 1, 0, 0)))
pmlogis_first(qmlogis_first(c(1, 0, 0, 0)))
pmlogis_last(qmlogis_last(c(1, 0)))
pmlogis_last(qmlogis_last(c(0, 1)))
pmlogis_last(qmlogis_last(c(0, 0, 1)))
pmlogis_last(qmlogis_last(c(0, 1, 0, 0)))
pmlogis_last(qmlogis_last(c(1, 0, 0, 0)))

}
