% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/letterValue.R
\name{letterValue}
\alias{letterValue}
\alias{letterV_B_g_h}
\alias{letterV_B_h}
\alias{letterV_B}
\alias{letterV_g}
\title{Letter-Value Estimation of Tukey \eqn{g}-&-\eqn{h} Distribution}
\usage{
letterValue(
  x,
  p_g = seq.int(from = 0.15, to = 0.25, by = 0.005),
  p_h = seq.int(from = 0.15, to = 0.35, by = 0.005),
  halfSpread = c("both", "lower", "upper"),
  ...
)

letterV_B_g_h(A, g, p_h, x, halfSpread, ...)

letterV_B_h(A, p_h, x, halfSpread)

letterV_B(A, g, p_g, x, halfSpread)

letterV_g(A, p_g, x)
}
\arguments{
\item{x}{\link[base]{double} vector, one-dimensional observations}

\item{p_g}{\link[base]{double} vector, the probabilities used for estimating parameter \eqn{g}.
Or, use \code{p_g = FALSE} to implement the constraint \eqn{g=0}.}

\item{p_h}{\link[base]{double} vector, the probabilities used for estimating parameter \eqn{h}.
Or, use \code{p_h = FALSE} to implement the constraint \eqn{h=0}.}

\item{halfSpread}{\link[base]{character} scalar, 
either to use \code{'both'} half-spreads (default),
\code{'lower'} half-spread, or \code{'upper'} half-spread.}

\item{...}{additional parameters, currently not in use}

\item{A, g}{estimated mean \eqn{\hat{A}} and skewness \eqn{\hat{g}} of Tukey's \eqn{g}-&-\eqn{h} distribution}
}
\value{
\link{letterValue} returns a \link[base]{double} vector of estimates \eqn{(\hat{A}, \hat{B}, \hat{g}, \hat{h})}
for a Tukey's \eqn{g}-&-\eqn{h} distribution.
}
\description{
Letter-value based estimation (Hoaglin, 2006) of 
Tukey \eqn{g}-&-\eqn{h} distribution and its constrained versions (\eqn{g}-distribution, \eqn{h}-distribution).

All equation numbers mentioned below refer to Hoaglin (2006).
}
\details{
\link{letterV_g} estimates parameter \eqn{g} using equation (10).

\link{letterV_B} estimates parameter \eqn{B} for Tukey's \eqn{g}-distribution
i.e., when \eqn{h=0} and \eqn{g\neq 0}, using equation (8a) and (8b).

\link{letterV_B_g_h} estimates parameters \eqn{B} and \eqn{h} when \eqn{g\neq 0}, using equation (33).

\link{letterV_B_h} estimates parameters \eqn{B} and \eqn{h} for Tukey's \eqn{h}-distribution,
i.e., when \eqn{g=0} and \eqn{h\neq 0}, using equation (26a), (26b) and (27).

\code{letterValue} plays a similar role as \code{fitdistrplus:::start.arg.default},
thus extends \link[fitdistrplus]{fitdist} for estimating Tukey's \eqn{g}-&-\eqn{h} distributions.
}
\examples{
set.seed(77652); x = rGH(n = 1e3L, g = -.3, h = .1)
letterValue(x, p_g = FALSE, p_h = FALSE)
letterValue(x, p_g = FALSE)
letterValue(x, p_h = FALSE)

(y0 = letterValue(x))
library(fitdistrplus)
fit <- fitdist(x, distr = 'GH', start = as.list.default(y0))
autoplot(fit)


}
\references{
Hoaglin, D.C. (2006). Summarizing Shape Numerically: The \eqn{g}-and-\eqn{h} Distributions. 
In \emph{Exploring Data Tables, Trends, and Shapes} (eds D.C. Hoaglin, F. Mosteller and J.W. Tukey),
Wiley Series in Probability and Statistics.
\doi{10.1002/9781118150702.ch11}
}
\seealso{
\link[fitdistrplus]{fitdist}
}
