% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/letterValue.R
\name{letterValue}
\alias{letterValue}
\alias{letterV_B_g_h}
\alias{letterV_B_h}
\alias{letterV_B}
\alias{letterV_g}
\title{Letter-Value Estimation of Tukey \eqn{g}-&-\eqn{h} Distribution}
\usage{
letterValue(
  x,
  p_g = seq.int(from = 0.15, to = 0.25, by = 0.005),
  p_h = seq.int(from = 0.15, to = 0.35, by = 0.005),
  halfSpread = c("both", "lower", "upper"),
  ...
)

letterV_B_g_h(A, g, p_h, x, halfSpread, ...)

letterV_B_h(A, p_h, x, halfSpread)

letterV_B(A, g, p_g, x, halfSpread)

letterV_g(A, p_g, x)
}
\arguments{
\item{x}{\link[base]{double} \link[base]{vector}, one-dimensional observations}

\item{p_g}{\link[base]{double} \link[base]{vector}, probabilities used for estimating \eqn{g} parameter.
Or, use \code{p_g = FALSE} to implement the constraint \eqn{g=0}
(i.e., an \eqn{h}-distribution is estimated).}

\item{p_h}{\link[base]{double} \link[base]{vector}, probabilities used for estimating \eqn{h} parameter.
Or, use \code{p_h = FALSE} to implement the constraint \eqn{h=0}
(i.e., a \eqn{g}-distribution is estimated).}

\item{halfSpread}{\link[base]{character} scalar,
either to use \code{'both'} half-spreads (default),
\code{'lower'} half-spread, or \code{'upper'} half-spread.}

\item{...}{additional parameters, currently not in use}

\item{A, g}{estimated location \eqn{\hat{A}} and skewness \eqn{\hat{g}}}
}
\value{
\link{letterValue} returns a \link[base]{double} \link[base]{vector} of estimates \eqn{(\hat{A}, \hat{B}, \hat{g}, \hat{h})}
for a Tukey's \eqn{g}-&-\eqn{h} distribution.
}
\description{
Letter-value based estimation (Hoaglin, 2006) of
Tukey's \eqn{g}-, \eqn{h}- and \eqn{g}-&-\eqn{h} distribution.
All equation numbers mentioned below refer to Hoaglin (2006).
}
\details{
\link{letterV_g} estimates parameter \eqn{g} using equation (10) for \eqn{g}-distribution
and the equivalent equation (31) for \eqn{g}-&-\eqn{h} distribution.

\link{letterV_B} estimates parameter \eqn{B} for Tukey's \eqn{g}-distribution
(i.e., \eqn{g\neq 0}, \eqn{h=0}), using equation (8a) and (8b).

\link{letterV_B_g_h} estimates parameters \eqn{B} and \eqn{h} when \eqn{g\neq 0}, using equation (33).

\link{letterV_B_h} estimates parameters \eqn{B} and \eqn{h} for Tukey's \eqn{h}-distribution,
i.e., when \eqn{g=0} and \eqn{h\neq 0}, using equation (26a), (26b) and (27).

\link{letterValue} plays a similar role as \code{fitdistrplus:::start.arg.default},
thus extends \link[fitdistrplus]{fitdist} for estimating Tukey's \eqn{g}-&-\eqn{h} distributions.
}
\examples{
set.seed(77652); x = rGH(n = 1e3L, g = -.3, h = .1)
letterValue(x, p_g = FALSE, p_h = FALSE)
letterValue(x, p_g = FALSE)
letterValue(x, p_h = FALSE)

(y0 = letterValue(x))
library(fitdistrplus)
fit = fitdist(x, distr = 'GH', start = as.list.default(y0))
plot(fit) # fitdistrplus:::plot.fitdist

}
\references{
Hoaglin, D.C. (2006). Summarizing Shape Numerically: The \eqn{g}-and-\eqn{h} Distributions.
\doi{10.1002/9781118150702.ch11}
}
