% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuantumClone.R
\name{CellularitiesFromFreq}
\alias{CellularitiesFromFreq}
\title{Cellularities from allele frequency}
\usage{
CellularitiesFromFreq(chr, position, Alt, Depth, Freec_ratio = NULL,
  Genotype = NULL, subclone.genotype = NULL, subclone.cell = NULL,
  contamination, restrict.to.AB = FALSE, force.single.copy = FALSE)
}
\arguments{
\item{chr}{The chromosome on which is the position (numeric value, not chr1 as in BED files)}

\item{position}{The genomic position of the mutation}

\item{Alt}{Number of reads supporting the variation}

\item{Depth}{Number of reads mapped at the position}

\item{Freec_ratio}{The FREEC output associated with the sample of interest}

\item{Genotype}{If the FREEC output is not given, the genotype associated with the locus (for example AAB)}

\item{subclone.genotype}{If existing, the genotype of the subclone. Else NULL}

\item{subclone.cell}{The cellular prevalence of the subclone which has a different Copy Number at this site}

\item{contamination}{The fraction of normal cells in the sample}

\item{restrict.to.AB}{Should the analysis keep only sites located in A and AB sites in all samples?}

\item{force.single.copy}{Should all mutations in overdiploid regions set to single copy? Default is FALSE}
}
\description{
Creates all possibilities for one mutation in one sample (given a genotype), then computes
the cellularity associated with each possibility and finally the probability of each possibility
}
\keyword{Clonal}
\keyword{inference}

