% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/QuantumClone_v3.R
\name{QuantumClone}
\alias{QuantumClone}
\title{One step analysis function}
\usage{
QuantumClone(SNV_list, FREEC_list = NULL, contamination, nclone_range = 2:5,
  clone_priors = NULL, prior_weight = NULL, simulated = F,
  save_plot = T, epsilon = 5 * (10^(-3)), maxit = 8, preclustering = T,
  timepoints = NULL, ncores = 1, output_directory = NULL)
}
\arguments{
\item{SNV_list}{A list of dataframes (one for each sample), with as columns : (for the first column of the first sample the name of the sample),
the chromosome "Chr",the position of the mutation "Start", the number of reads supporting the mutation "Alt", the depth of coverage at this locus "Depth",
and if the output from FREEC for the samples are not associated, the genotype "Genotype".}

\item{FREEC_list}{list of dataframes from FREEC for each samples (usually named Sample_ratio.txt), in the same order as SNV_list}

\item{contamination}{Numeric vector describind the contamination in all samples (ranging from 0 to 1). Default is 0.}

\item{nclone_range}{A number or range of clusters that should be used for clustering}

\item{clone_priors}{List of vectors with the putated position of clones}

\item{prior_weight}{Numeric with the proportion mutations in each clone}

\item{simulated}{Should be TRUE if the data has been been generated by the QuantumCat algorithm}

\item{save_plot}{Should the plots be saved? Default is TRUE}

\item{epsilon}{Stop value: maximal admitted value of the difference in cluster position and weights between two optimization steps.}

\item{maxit}{Number of initial conditions to be tested for the EM algorithm}

\item{preclustering}{Boolean: should a kmeans be performed on A and AB sites to determine priors}

\item{timepoints}{a numeric vector indicating if the samples are from different timepoints or tumors (e.g. one tumor and metastates) If NULL,
all samples are considered from the same tumor.}

\item{ncores}{Number of cores to be used during EM algorithm}

\item{output_directory}{Path to output directory}
}
\description{
Sequentially calls a function to test all accessible cellularities for all mutations in the samples,then cluster them, and finally draws
phylogenetic trees based on the uncovered cellularities
}
\examples{
cat("Generate data : 2 clones ; 10 observed mutations; diploid tumor ;
                         1000x sequencing depth; 2 samples; no contamination")
Mutations<-QuantumCat(number_of_clones=2,number_of_mutations=10,ploidy="AB",depth=1000,
                      number_of_samples=2,Random_clones=FALSE,contamination=c(0,0))
 for(i in 1:2){
 Mutations[[i]]<-cbind(rep(paste("Example_",i,sep=""),times=10),Mutations[[i]])
 colnames(Mutations[[i]])[1]<-"Sample"
}
print("The data should look like this:")
print(head(Mutations[[1]][,c(1:4,8,9)]))

cat("Cluster data: will try to cluster between 2 and 3 clones, with 1 maximum search each time,
      and will use priors from preclustering (e.g. k-medoids on A and AB sites)")
print("The genotype is provided in the list frame, and
          there is no associated data from FREEC to get genotype from.")
print("The computation will run on a single CPU.")
Clustering_output<-QuantumClone(SNV_list = Mutations,
FREEC_list = NULL,contamination = c(0,0),nclone_range = 2:3,
clone_priors = NULL,prior_weight = NULL ,
maxit = 1,preclustering = TRUE, simulated = TRUE,
save_plot = TRUE,ncores=1,output_directory="Example")
print("The data can be accessed by Clustering_output$filtered_data")
print("All plots are now saved in the working directory")
}
\keyword{Cancer}
\keyword{Clonal}
\keyword{inference}
\keyword{phylogeny}

