% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation_tools.R
\name{NMI_cutree}
\alias{NMI_cutree}
\title{NMI}
\usage{
NMI_cutree(cut_tree, chr)
}
\arguments{
\item{cut_tree}{a numeric vector of cluster selection}

\item{chr}{the ground truth for clusters}
}
\value{
numeric value of NMI (between 0 and 1)
}
\description{
Computes the NMI based on the clustering
}
\examples{
set.seed(123)
#1: Cluster data
FQC<-FlashQC(QuantumClone::Input_Example,conta = c(0,0),Nclus = 2:10)

#2: Compute NMI
NMI_cutree(FQC$cluster,chr = QuantumClone::Input_Example[[1]]$Chr)
}
