% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuartetDistance.R
\name{PlotQuartet}
\alias{PlotQuartet}
\title{Plot quartet on tree topologies}
\usage{
PlotQuartet(tree, quartet, overwritePar = TRUE, caption = TRUE, ...)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}},
or a list of such trees.  The first member of \code{tree} will be considered
the 'reference' tree.}

\item{quartet}{A vector of four integers, corresponding to numbered leaves on
the tree; or a character vector specifying the labels of four leaves.}

\item{overwritePar}{Logical specifying whether to use existing \code{mfrow} and
\code{mar} parameters from \code{\link[graphics]{par}()} (\code{FALSE}),
or to plot trees side-by-side in a new graphical device (\code{TRUE}).}

\item{caption}{Logical specifying whether to annotate each plot to specify
whether the quartet selected is in the same or a different state to the
reference tree.}

\item{\dots}{Additional parameters to send to
\code{\link[ape:plot.phylo]{plot}()}.}
}
\value{
\code{PlotQuartet()} returns \code{invisible()}, having plotted a tree in
which the first two members of \code{quartet} are highlighted in orange, and the
second two highlighted in blue.
}
\description{
Draws a tree, highlighting the members of a specified quartet in colour.
}
\examples{
data("sq_trees")

oPar <- par(mfrow = c(3, 6), mar = rep(0.5, 4))
PlotQuartet(sq_trees, c(2, 5, 3, 8), overwritePar = FALSE)
par(oPar)

}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
