% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluorescence_summaries.R
\name{summary.drFitfl}
\alias{summary.drFitfl}
\title{Generic summary function for drFitfl objects}
\usage{
\method{summary}{drFitfl}(object, ...)
}
\arguments{
\item{object}{object of class \code{drFitfl}}

\item{...}{Additional arguments. This has currently no effect and is only meant to fulfill the requirements of a generic function.}
}
\value{
A dataframe with parameters for all samples extracted from a dose-response analysis.
}
\description{
Generic summary function for drFitfl objects
}
\examples{
# load example dataset
input <- read_data(data.growth = system.file('lac_promoters.xlsx', package = 'QurvE'),
                   data.fl = system.file('lac_promoters.xlsx', package = 'QurvE'),
                   sheet.growth = 1,
                   sheet.fl = 2 )

# Define fit controls
control <- fl.control(fit.opt = 's',
             x_type = 'time', norm_fl = TRUE,
             dr.parameter = 'max_slope.spline',
             dr.method = 'model',
             suppress.messages = TRUE)

# Run curve fitting workflow
res <- flFit(fl_data = input$norm.fluorescence,
             time = input$time,
             parallelize = FALSE,
             control = control)

# Perform dose-response analysis with biosensor model
drFitfl <- fl.drFit(flTable = res$flTable, control = control)

summary(drFitfl)

}
