% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_tables.R
\name{table_group_growth_model}
\alias{table_group_growth_model}
\title{Generate a grouped results table for parametric fits with average and standard deviations}
\usage{
table_group_growth_model(gcTable, html = FALSE)
}
\arguments{
\item{gcTable}{An object of class \code{gcTable}}

\item{html}{(Logical) Should column headers contain html formatting?}
}
\value{
A data frame with grouped model fit results. Empty cells indicate that no reliable fit could be determined.
}
\description{
Generate a grouped results table for parametric fits with average and standard deviations
}
\examples{
# Create random growth data set
rnd.data <- rdm.data(d = 35, mu = 0.8, A = 5, label = "Test1")


# Run growth curve analysis workflow
res <- growth.workflow(time = rnd.data$time,
                       data = rnd.data$data,
                       fit.opt = "m",
                       ec50 = FALSE,
                       export.res = FALSE,
                       parallelize = FALSE,
                       suppress.messages = TRUE)

table_group_growth_model(res$gcFit$gcTable)

# with HTML formatting
DT::datatable(table_group_growth_model(res$gcFit$gcTable, html = TRUE),
              escape = FALSE) # Do not escape HTML entities

}
