% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Postprocessing.R
\name{plotResultInteractive}
\alias{plotResultInteractive}
\title{Interactive plotting of results}
\usage{
plotResultInteractive(preparedOutput, varEnv, envFile, species = NULL,
  pass = NULL, x = NULL, y = NULL, valueName = "pvalueG",
  chromo = "all", gdsFile = NULL, IDCol = NULL, popStrCol = NULL)
}
\arguments{
\item{preparedOutput}{char The prepared output list from prepare_output function}

\item{varEnv}{char The name of the environmental variable one wish to study (as in the header of \code{envFile})}

\item{envFile}{char The file containing the input environmental variable of sambada.}

\item{species}{char The abbreviated latin name of the species without capitals nor punctuation (e.g. btaurus, chircus,...). Can be set to null if species not present in ensembl database}

\item{pass}{integer Number of BP around a SNP in which to look for an annotation in Ensembl. Set to null if species is null}

\item{x}{char The name of the column corresponding to the x-coordinate in the envFile. Can be set to null if unknown, in this case the maps will not be available}

\item{y}{char The name of the column corresponding to the y-coordinate in the env file. Can be set to null if x is null.}

\item{valueName}{char Name of the p- or q-value one wish to plot the manhattan on. This can be either pvalueG, pvalueW, qvalueG, qvalueW for G- or Waldscore respectively.}

\item{chromo}{char/integer Name or vector of name of the chromosome to investigate. If all is chosen (default), all numerical chromosome will be mapped. If your sambada output is large (typically if you are working with more than 50K genomic file), you should probably map a subset of your dataset (e.g. \code{chromo}=1)}

\item{gdsFile}{char The GDS file created in the preprocessing of sambada. If null, will try with envFile(without -env.csv or -env-export.csv) and .gds}

\item{IDCol}{char The name of the column in \code{envFile} corresponding to the ID of the individual. If provided, hover on the output map will give the id of the animal}

\item{popStrCol}{char The name or vector of name of column(s) in \code{envFile} describing population structure. If provided, additional layers on the map will be available representing population structure.}
}
\value{
None
}
\description{
Plots the manhattan plot for a given environmental variable. The plot is interactive and a map of the distribution of the marker can be retrieved as well as nearby genes listed in Ensembl.
}
\examples{
\dontrun{
# Example with data from the package
# First copy needed files into the temporary directory
file.copy(system.file("extdata", "uganda-subset-mol-Out-2.csv", package = "R.SamBada"), 
     file.path(tempdir(),'uganda-subset-mol-Out-2.csv'), overwrite=TRUE)
file.copy(system.file("extdata", "uganda-subset-mol-storey.csv", package = "R.SamBada"), 
     file.path(tempdir(),'uganda-subset-mol-storey.csv'), overwrite=TRUE)
file.copy(system.file("extdata", "uganda-subset-env-export.csv", package = "R.SamBada"), 
     file.path(tempdir(),'uganda-subset-env-export.csv'), overwrite=TRUE)
if(Sys.info()['sysname']=='Windows'){
  file.copy(system.file("extdata", "uganda-subset-mol_windows.gds", package = "R.SamBada"),
      file.path(tempdir(),'uganda-subset-mol.gds'), overwrite=TRUE) #If you run Windows
} else {
  file.copy(system.file("extdata", "uganda-subset-mol_unix.gds", package = "R.SamBada"),
      file.path(tempdir(),'uganda-subset-mol.gds'), overwrite=TRUE)
}
# Run prepareOutput
prep=prepareOutput(file.path(tempdir(),'uganda-subset-mol'),2,popStr=TRUE,
     interactiveChecks=FALSE)
###################
# Run plotResultInteractive
###################
plotResultInteractive(prep,'bio1','uganda-subset-env-export.csv',species='btaurus',
     pass=25000,x='longitude',y='latitude', gdsFile='uganda-subset-mol.gds',
     IDCol='short_name',popStrCol='pop1')
}
}
\author{
Solange Duruz
}
