% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/scaleBack.lm.R
\name{scaleBack.lm}
\alias{scaleBack.lm}
\title{Transform back multiple regression coefficients to unscaled regression coefficients
Original question posed by Mark Seeto on the R mailing list.}
\usage{
scaleBack.lm(X, Y, betas.scaled)
}
\arguments{
\item{X,}{unscaled design matrix without the intercept, m by n matrix}

\item{Y,}{unscaled response, m by 1 matrix}

\item{betas.scaled,}{coefficients vector of multiple regression, first term is the intercept}
}
\description{
Transform back multiple regression coefficients to unscaled regression coefficients
Original question posed by Mark Seeto on the R mailing list.
}
\note{
2015-04-10
}
\examples{
set.seed(4242)
 X            <- matrix(rnorm(12), 4, 3)
 Y            <- matrix(rnorm(4), 4, 1)
 betas.scaled <- matrix(rnorm(3), 3, 1)
 betas        <- scaleBack.lm(X, Y, betas.scaled)
}
\author{
M.Suzen
}

