% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcDT.R
\name{detectWeirdLevelNamesDT}
\alias{detectWeirdLevelNamesDT}
\title{Detecting which levels of which factor of a data.table object contain non-alpha numeric characters (including whitespace) characters}
\usage{
detectWeirdLevelNamesDT(inputDT)
}
\arguments{
\item{inputDT}{data.table object containing the data of interest. This is an obligatory argument, without default value.}
}
\value{
No value is returned. Note that a valid value needs to be supplied to the 'colNamesToBeChecked' argument in order to make this function work.
}
\description{
Detecting which levels of which factor of a data.table object contain non-alpha numeric characters (including whitespace) characters
}
\examples{
library(data.table)
inputDT <- as.data.table(data.frame(x = seq(1, 20, 2)))
detectWeirdLevelNamesDT(inputDT)

inputDT <- as.data.table(data.frame(x = seq(1, 20, 2), y = LETTERS[1:10]))
detectWeirdLevelNamesDT(inputDT)

inputDT <- as.data.table(data.frame(x = c(rep('test_', 5), rep('test@', 5)),
y = c(rep('test_', 5), rep('test@', 5))))
\donttest{detectWeirdLevelNamesDT(inputDT)}
}
