% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Formula.translate.R
\name{Formula.translate}
\alias{Formula.translate}
\title{An internal function to translate an R formula into an R list object.}
\usage{
Formula.translate(Formula, D = "Normal", indata)
}
\arguments{
\item{Formula}{A \code{\link[stats]{formula}} object specifying a multilevel model.
See \code{\link[stats]{formula}} for notes on general usage, and \code{\link{runMLwiN}} for
further details.}

\item{D}{A character string/vector specifying the type of distribution to be modelled, which
can include \code{'Normal'} (the default), \code{'Binomial'}, \code{'Poisson'},
\code{'Negbinom'}, \code{'Unordered Multinomial'}, \code{'Ordered Multinomial'},
\code{'Multivariate Normal'}, or \code{'Mixed'}. In the case of the latter,
\code{'Mixed'} precedes the response types which also need to be listed in
\code{D}, e.g. \code{c('Mixed', 'Normal', 'Binomial')}; these need to be
be listed in the same order to which they are referred to in the
\code{Formula} object.}

\item{indata}{A data.frame object containing the data to be modelled.
Optional (can \code{\link[base]{attach}} as an alternative) but recommended.}
}
\value{
Outputs an R list object, which is then used as the input for
\code{\link{write.IGLS}} or \code{\link{write.MCMC}}.
}
\description{
A model formula, as a formula object written in R-type syntax, is translated
into an R list object.
}
\examples{
\dontrun{
# NB: See demo(packge = 'R2MLwiN') for a wider range of examples.
library(R2MLwiN)
# NOTE: if MLwiN not saved in location R2MLwiN defaults to, specify path via:
# options(MLwiN_path = 'path/to/MLwiN vX.XX/')
# If using R2MLwiN via WINE, the path may look like this:
# options(MLwiN_path = '/home/USERNAME/.wine/drive_c/Program Files (x86)/MLwiN vX.XX/')

# Two-level random intercept model with student (level 1) nested within
# school (level 2) and standlrt added to the fixed part.
# Importantly, the ordering of school and student reflects their hierarchy,
# with the highest level (school) specified first.
# E.g. see demo(UserGuide04)
data(tutorial, package = 'R2MLwiN')
(mymodel1 <- runMLwiN(normexam ~ 1 + standlrt + (1 | school) + (1 | student),
                     data = tutorial))

# Adding a random slope
(mymodel2 <- runMLwiN(normexam ~ 1 + standlrt + (1 + standlrt | school)
                     + (1 | student), data = tutorial))

# Exploring complex level 1 variation
# E.g. see demo(UserGuide07)
(mymodel3 <- runMLwiN(normexam ~ 1 + standlrt + (1 + standlrt | school)
                      + (1 + standlrt | student), data = tutorial))

# Logit link with cons specified as denominator
# Note level 1 ID not explicitly specified
# E.g. see demo(UserGuide09)
data(bang, package = 'R2MLwiN')
(mymodel4 <- runMLwiN(logit(use, cons) ~ 1 + lc + age + (1 | district),
                      D = 'Binomial', data = bang))

# Mixed response model
# Note using MCMC estimation (EstM = 1)
# Normal (english) and Bernoulli (behaviour) distributed responses
# probit link modelling behaviour with cons as denominator
# E.g. see demo(MCMCGuide19)
data(jspmix1, package = 'R2MLwiN')
(mymodel <- runMLwiN(c(english, probit(behaviour, cons)) ~
                     1 + sex + ravens + fluent[1] + (1 | school) + (1[1] | id),
                     D = c('Mixed', 'Normal', 'Binomial'),
                     estoptions = list(EstM = 1,
                     mcmcMeth = list(fixM = 1, residM = 1, Lev1VarM = 1)),
                     data = jspmix1))
}

}
\author{
Zhang, Z., Charlton, C.M.J., Parker, R.M.A., Leckie, G., and Browne,
W.J. (2016) Centre for Multilevel Modelling, University of Bristol.
}
\seealso{
\code{\link{runMLwiN}}, \code{\link{write.IGLS}}, \code{\link{write.MCMC}}; for
function allowing back-compatibility with Formula syntax used in older
versions of \pkg{R2MLwiN} (<0.8.0) see \code{\link{Formula.translate.compat}}.
}

