% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test2cl.R
\name{test2cl}
\alias{test2cl}
\title{Test2.CL}
\usage{
test2cl(X, freq, verbose = TRUE, rounding = 3)
}
\arguments{
\item{X}{is a matrix of encounter histories with K occasions}

\item{freq}{is a vector of the number of individuals with the corresponding encounter history}

\item{verbose}{controls the level of the details in the outputs; default is TRUE for all details}

\item{rounding}{is the level of rounding for outputs; default is 3}
}
\value{
This function returns a list with first component the overall test and second component a data.frame with 5 columns for components i (2:K-3) (in rows) of test2.cli following Pradel 1993 (in Lebreton and North, Birkhauser Verlag): component, degree of freedom, statistic of the test, p-value, test performed.
}
\description{
This function performs Test2.CL
}
\examples{
# read in the classical dipper dataset
dipper = system.file("extdata", "ed.inp", package = "R2ucare")
dipper = read_inp(dipper,group.df=data.frame(sex=c('Male','Female')))

# Get encounter histories, counts and groups:
dip.hist = dipper$encounter_histories
dip.freq = dipper$sample_size
dip.group = dipper$groups

# split the dataset in males/females
mask = (dip.group == 'Female')
dip.fem.hist = dip.hist[mask,]
dip.fem.freq = dip.freq[mask]
mask = (dip.group == 'Male')
dip.mal.hist = dip.hist[mask,]
dip.mal.freq = dip.freq[mask]

# for males
X = dip.mal.hist
freq = dip.mal.freq
res.males = test2cl(X,freq)
res.males
}
\author{
Olivier Gimenez <olivier.gimenez@cefe.cnrs.fr>, Jean-Dominique Lebreton, Rémi Choquet, Roger Pradel
}
\keyword{package}

