% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq.r
\name{freq}
\alias{freq}
\title{Calculate frequency statistics on data frame}
\usage{
freq(
  dfrm,
  vars,
  id,
  denom = nrow(dfrm),
  dig = 2,
  total = NULL,
  totaldenom = nrow(dfrm),
  spacechar = NULL
)
}
\arguments{
\item{dfrm}{data frame to calculate the statistics on}

\item{vars}{character vector of variable(s) within the data frame to perform the statistics on}

\item{id}{character vector of variable(s). In case id is set the function will take into account non duplicated values
for id in the calculations.}

\item{denom}{the denominator for the calculation of percentage. See details for valid options}

\item{dig}{number of digits to use for output percentage (frequency is displayed as integer)}

\item{total}{vector of variable(s) within the data frame to calculate totals on}

\item{totaldenom}{the denominator for the calculation of percentage of the totals. See details for valid arguments}

\item{spacechar}{the character to use for space for combined frequency and percentage in output (e.g. "~" for tex documents)}
}
\value{
The function returns a dataframe with frequencies and percentages
}
\description{
This function calculates frequency statistics on a data frame. It is intended to use to
calculate the frequency and percentages based on a predefined denominator.
}
\details{
The function calculates frequency statistics of variable(s) within a data frame. Furthermore, the frequencies for a total
can also be generated. To calculate the percentages, the denominator should be supplied (and in case totals has a value also totaldenom).
The denom and totaldenom can be a constant numerical value, a variable within the data frame or a separate data frame. In case the argument
is a data frame, the function will attempt to merge this data frame based on equal variables within dfrm/denom and dfrm/totaldenom.
The possibility for a separate denominator is implemented as in many cases the denominator is not the total number of observations
but is defined elsewhere (e.g. for number of adverse events, the total number of subjects is used as denominator).
}
\examples{

data(Indometh)
freq(Indometh,vars="time",id="Subject",
        denom=nrow(Indometh),total="",totaldenom=nrow(Indometh))
}
