% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_optimal_portfolio.R
\name{plot_optimal_portfolio}
\alias{plot_optimal_portfolio}
\title{Plot optimal portfolio allocations}
\usage{
plot_optimal_portfolio(portfolio)
}
\arguments{
\item{portfolio}{A nested \code{tibble} of class \code{Portfolio}.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
The function plots current versus optimal
portfolio allocations for each asset class
and for taxable and tax-advantaged accounts.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
older_member <- HouseholdMember$new(
  name       = "older",  
  birth_date = "1980-02-15",
  mode       = 80,
  dispersion = 10
)  
household <- Household$new()
household$add_member(older_member)  

household$expected_income <- list(
  "income" = c(
    "members$older$age <= 65 ~ 7000 * 12"
  )
)
household$expected_spending <- list(
  "spending" = c(
    "TRUE ~ 5000 * 12"
  )
)

portfolio <- create_portfolio_template() 
portfolio$accounts$taxable <- c(10000, 30000)
portfolio$accounts$taxadvantaged <- c(0, 20000)
portfolio <- 
  portfolio |> 
  calc_effective_tax_rate(
    tax_rate_ltcg = 0.20, 
    tax_rate_ordinary_income = 0.40
  )

portfolio <- 
  calc_optimal_asset_allocation(
   household = household,
   portfolio = portfolio,
   current_date = "2020-07-15"
  )

plot_optimal_portfolio(portfolio)
\dontshow{\}) # examplesIf}
}
