% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_scenario_snapshot.R
\name{render_scenario_snapshot}
\alias{render_scenario_snapshot}
\title{Rendering a scenario snapshot}
\usage{
render_scenario_snapshot(scenario, index = 0, currency = "", big_mark = " ")
}
\arguments{
\item{scenario}{A \code{tibble} with nested columns -
the result of \code{\link[=simulate_scenario]{simulate_scenario()}}. Data for a single scenario.}

\item{index}{The index of the scenario year to render.
By default, it is 0, which corresponds to the current year.}

\item{currency}{The currency symbol to use as a suffix.}

\item{big_mark}{The character to use as a big mark.
It separates thousands.}
}
\value{
A \code{\link[gt:gt]{gt::gt()}} object.
}
\description{
Rendering a scenario snapshot
}
\examples{
older_member <- HouseholdMember$new(
  name       = "older",  
  birth_date = "1980-02-15",
  mode       = 80,
  dispersion = 10
)  
household <- Household$new()
household$add_member(older_member)  

household$expected_income <- list(
  "income" = c(
    "members$older$age <= 65 ~ 9000 * 12"
  )
)
household$expected_spending <- list(
  "spending" = c(
    "members$older$age <= 65 ~ 5000 * 12",
    "TRUE ~ 4000 * 12"
  )
)

portfolio <- create_portfolio_template() 
portfolio$accounts$taxable <- c(10000, 30000)
portfolio <- 
  portfolio |> 
  calc_effective_tax_rate(
    tax_rate_ltcg = 0.20, 
    tax_rate_ordinary_income = 0.40
  )

scenario <- 
  simulate_scenario(
   household = household,
   portfolio = portfolio,
   current_date = "2020-07-15"
  )
render_scenario_snapshot(scenario)
}
